/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Expressions.LeftRightGuardExpression;
import dk.aau.cs.model.CPN.Variable;
import java.util.Set;

public class LessThanExpression
extends GuardExpression
implements LeftRightGuardExpression {
    private ColorExpression left;
    private ColorExpression right;

    public LessThanExpression(ColorExpression left, ColorExpression right) {
        this(left, right, null);
    }

    public LessThanExpression(ColorExpression left, ColorExpression right, ColorType colorType) {
        this.left = left;
        this.right = right;
        this.colorType = colorType;
    }

    @Override
    public ColorExpression getLeftExpression() {
        return this.left;
    }

    @Override
    public ColorExpression getRightExpression() {
        return this.right;
    }

    @Override
    public boolean containsColor(Color color) {
        return this.left.containsColor(color) || this.right.containsColor(color);
    }

    @Override
    public GuardExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (this == object1 && object2 instanceof GuardExpression) {
            GuardExpression obj2 = (GuardExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        this.left = this.left.replace(object1, object2, replaceAllInstances);
        this.right = this.right.replace(object1, object2, replaceAllInstances);
        this.colorType = this.left.getColorType();
        return this;
    }

    @Override
    public GuardExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public GuardExpression copy() {
        return new LessThanExpression(this.left, this.right);
    }

    @Override
    public boolean containsPlaceHolder() {
        return this.left.containsPlaceHolder() || this.right.containsPlaceHolder();
    }

    @Override
    public Expression findFirstPlaceHolder() {
        if (this.left.containsPlaceHolder()) {
            return this.left.findFirstPlaceHolder();
        }
        if (this.right.containsPlaceHolder()) {
            return this.right.findFirstPlaceHolder();
        }
        return null;
    }

    @Override
    public void getValues(ExprValues exprValues) {
        this.left.getValues(exprValues);
        this.right.getValues(exprValues);
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        this.left.getVariables(variables);
        this.right.getVariables(variables);
    }

    @Override
    public Boolean eval(ExpressionContext context) {
        return null;
    }

    public String toString() {
        return this.left.toString() + " < " + this.right.toString();
    }

    @Override
    public boolean isSimpleProperty() {
        return false;
    }

    @Override
    public ExprStringPosition[] getChildren() {
        ExprStringPosition pos;
        ExprStringPosition[] children = new ExprStringPosition[2];
        int endPrev = 0;
        int start = 0;
        int end = 0;
        endPrev = end = start + this.left.toString().length();
        children[0] = pos = new ExprStringPosition(start, end, this.left);
        start = endPrev + 3;
        end = start + this.right.toString().length();
        children[1] = pos = new ExprStringPosition(start, end, this.right);
        return children;
    }

    public boolean equals(Object o) {
        if (o instanceof LessThanExpression) {
            LessThanExpression expr = (LessThanExpression)o;
            return this.left.equals(expr.left) && this.right.equals(expr.right);
        }
        return false;
    }
}

