/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Variable;
import java.util.Set;

public abstract class Expression {
    protected Expression parent;

    public boolean isSimpleProperty() {
        return true;
    }

    public void setParent(Expression parent) {
        this.parent = parent;
    }

    public ExprStringPosition objectAt(int index) {
        ExprStringPosition[] children;
        for (ExprStringPosition child : children = this.getChildren()) {
            if (child.getStart() > index || index > child.getEnd()) continue;
            int start = child.getStart();
            return child.getObject().objectAt(index - start).addOffset(start);
        }
        return new ExprStringPosition(0, this.toString().length(), this);
    }

    public ExprStringPosition indexOf(Expression property) {
        ExprStringPosition[] children;
        if (this == property) {
            return new ExprStringPosition(0, this.toString().length(), this);
        }
        for (ExprStringPosition child : children = this.getChildren()) {
            ExprStringPosition position = child.getObject().indexOf(property);
            if (position == null) continue;
            return position.addOffset(child.getStart());
        }
        return null;
    }

    public abstract Expression replace(Expression var1, Expression var2, boolean var3);

    public abstract Expression replace(Expression var1, Expression var2);

    public abstract Expression copy();

    public ExprStringPosition[] getChildren() {
        return new ExprStringPosition[0];
    }

    public abstract boolean containsPlaceHolder();

    public abstract Expression findFirstPlaceHolder();

    public abstract void getValues(ExprValues var1);

    public abstract void getVariables(Set<Variable> var1);

    public abstract boolean containsColor(Color var1);
}

