/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.ProductType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ColorType
implements Iterable<Color> {
    public static final ColorType COLORTYPE_DOT = new ColorType("dot"){
        {
            this.addColor("dot");
        }
    };
    private final Vector<Color> colors = new Vector();
    private final String id;
    private final String name;

    public ColorType(String name) {
        this(name, name);
    }

    public ColorType(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public void addColor(Color c) {
        this.colors.add(c);
    }

    public void addColor(String colorName) {
        this.addColor(new Color(this, (Integer)this.colors.size(), colorName));
    }

    public void addColors(List<String> colorNames) {
        for (String c : colorNames) {
            this.addColor(c);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Integer size() {
        return this.colors.size();
    }

    @Override
    @NotNull
    public Iterator<Color> iterator() {
        return this.colors.iterator();
    }

    public List<Color> getColorList() {
        return new ArrayList<Color>(this.colors);
    }

    public Vector<Color> getColors() {
        return this.colors;
    }

    public boolean isIdentical(ColorType newColorType) {
        boolean firstColorIdentical = this.getFirstColor().getColorName().equals(newColorType.getFirstColor().getColorName());
        boolean lastColorIdentical = this.getColors().lastElement().getColorName().equals(newColorType.getColors().lastElement().getColorName());
        return firstColorIdentical && lastColorIdentical && !this.equals(newColorType);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ColorType) || o instanceof ProductType) {
            return false;
        }
        ColorType object = (ColorType)o;
        if (!object.name.equals(this.name)) {
            return false;
        }
        if (!object.size().equals(this.size())) {
            return false;
        }
        for (int i = 0; i < this.colors.size(); ++i) {
            if (this.colors.get(i).equals(object.colors.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder("<html>" + this.name + "<b> is </b>[");
        for (Color element : this.colors) {
            out.append(element.getColorName()).append(", ");
        }
        out = new StringBuilder(out.substring(0, out.length() - 2));
        out.append("]</html>");
        return out.toString();
    }

    public Color successorTo(Color color, int offset) {
        int index = this.colors.indexOf(color);
        if (index == -1) {
            return null;
        }
        return this.colors.get((index + offset) % this.size());
    }

    public Color getFirstColor() {
        return this.colors.firstElement();
    }

    public boolean isProductColorType() {
        return this.getFirstColor().getTuple() != null && !this.getFirstColor().getTuple().isEmpty();
    }

    public Vector<ColorType> getProductColorTypes() {
        Vector<ColorType> colorTypes = new Vector<ColorType>();
        for (Color color : this.getFirstColor().getTuple()) {
            colorTypes.addElement(color.getColorType());
        }
        return colorTypes;
    }

    public ColorType copy() {
        ColorType ct = new ColorType(this.name);
        for (Color color : this.colors) {
            ct.addColor(color.getName());
        }
        return ct;
    }

    public boolean contains(Color color) {
        for (Color c : this.colors) {
            if (!c.getColorName().equals(color.getColorName())) continue;
            return true;
        }
        return false;
    }

    public Color getColorByName(String name) {
        for (Color c : this.colors) {
            if (!c.getColorName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public ColorExpression createColorExpressionForFirstColor() {
        return new UserOperatorExpression(this.getFirstColor());
    }

    public boolean isIntegerRange() {
        for (Color c : this.colors) {
            if (c.getColorName().matches("-?(0|[1-9]\\d*)")) continue;
            return false;
        }
        return true;
    }

    public Integer getLowerBound() {
        if (this.isIntegerRange()) {
            return Integer.parseInt(this.colors.get(0).getColorName());
        }
        return null;
    }

    public Integer getUpperBound() {
        if (this.isIntegerRange()) {
            return Integer.parseInt(this.colors.get(this.colors.size() - 1).getColorName());
        }
        return null;
    }
}

