/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ColorMultiset
implements Map<Color, Integer> {
    private final HashMap<Color, Integer> map = new HashMap();
    private final ColorType colorType;
    private int numberOfTokens = 0;

    public ColorMultiset(ColorType colorType, int numberOf, Iterable<Color> colors, Vector<ColorExpression> colorExpression) {
        this.colorType = colorType;
        if (numberOf > 0) {
            for (Color c : colors) {
                this.map.put(c, numberOf);
            }
            this.updateTokenNumber(colorExpression, numberOf);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    @Override
    public Integer get(Object o) {
        if (!this.containsKey(o)) {
            return 0;
        }
        return this.map.get(o);
    }

    @Override
    public Integer put(Color color, Integer integer) {
        if (!color.getColorType().equals(this.colorType)) {
            throw new IllegalArgumentException(String.format("Type mismatch: Attempted to put %s in multiset of type %s", color.getName(), this.colorType.getName()));
        }
        if (integer <= 0) {
            if (this.containsKey(color)) {
                Integer previous = this.get(color);
                this.remove(color);
                return previous;
            }
            return null;
        }
        return this.map.put(color, integer);
    }

    @Override
    public Integer remove(Object o) {
        return this.map.remove(o);
    }

    @Override
    public void putAll(Map<? extends Color, ? extends Integer> map) {
        for (Map.Entry<? extends Color, ? extends Integer> kv : map.entrySet()) {
            this.put(kv.getKey(), kv.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.numberOfTokens = 0;
    }

    @Override
    public Set<Color> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Integer> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Color, Integer>> entrySet() {
        return this.map.entrySet();
    }

    public void add(Color color, int count) {
        Integer result = this.get(color) + count;
        this.put(color, result);
    }

    public void sub(Color color, int count) {
        Integer result = this.get(color) - count;
        this.put(color, result);
    }

    public void addAll(Map<? extends Color, ? extends Integer> map, Vector<ColorExpression> colorExpressions, int numberOf) {
        this.updateTokenNumber(colorExpressions, numberOf);
        for (Map.Entry<? extends Color, ? extends Integer> kv : map.entrySet()) {
            this.add(kv.getKey(), kv.getValue());
        }
    }

    public void subAll(Map<? extends Color, ? extends Integer> map) {
        for (Map.Entry<? extends Color, ? extends Integer> kv : map.entrySet()) {
            this.sub(kv.getKey(), kv.getValue());
        }
    }

    public void scale(int scalar) {
        for (Map.Entry<Color, Integer> kv : this.entrySet()) {
            Color color = kv.getKey();
            Integer result = this.get(color) * scalar;
            this.put(color, result);
        }
    }

    private void updateTokenNumber(Vector<ColorExpression> colorExpression, int numberOf) {
        for (ColorExpression ce : colorExpression) {
            if (ce instanceof TupleExpression) {
                this.updateTupleTokenNumber(((TupleExpression)ce).getColors(), numberOf);
                continue;
            }
            if (ce instanceof AllExpression) {
                this.numberOfTokens += ((AllExpression)ce).size() * numberOf;
                continue;
            }
            this.numberOfTokens += numberOf;
        }
    }

    private void updateTupleTokenNumber(Vector<ColorExpression> colorExpression, int numberOf) {
        int numberOfTupleTokens = 1;
        for (ColorExpression ce : colorExpression) {
            if (!(ce instanceof AllExpression)) continue;
            if (numberOfTupleTokens < numberOf) {
                numberOfTupleTokens *= ((AllExpression)ce).size() * numberOf;
                continue;
            }
            numberOfTupleTokens *= ((AllExpression)ce).size().intValue();
        }
        this.numberOfTokens += Math.max(numberOfTupleTokens, numberOf);
    }

    public Vector<TimedToken> getTokens(TimedPlace place) {
        Vector<TimedToken> result = new Vector<TimedToken>();
        place.setNumberOfTokens(this.numberOfTokens);
        for (Map.Entry<Color, Integer> entry : this.entrySet()) {
            for (int i = 0; i < entry.getValue(); ++i) {
                result.add(new TimedToken(place, entry.getKey()));
            }
        }
        return result;
    }
}

