/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN;

import dk.aau.cs.model.CPN.ColorType;
import java.util.Vector;

public class Color {
    private final Vector<Color> tuple;
    private final ColorType colorType;
    private final String colorName;
    private final Integer id;
    public static final Color STAR_COLOR = new Color(new ColorType("*"), (Integer)0, "*");

    private Color(ColorType colorType, Integer id, Vector<Color> colors, String colorName) {
        this.tuple = colors;
        this.colorType = colorType;
        this.colorName = colorName;
        this.id = id;
    }

    public Color(ColorType colorType, Integer id, Vector<Color> colors) {
        this(colorType, id, colors, "");
    }

    public Color(ColorType colorType, Integer id, String color) {
        this(colorType, id, null, color);
    }

    public String getName() {
        return this.colorName;
    }

    public String getColorName() {
        return this.colorName;
    }

    public Vector<Color> getTuple() {
        return this.tuple;
    }

    public ColorType getColorType() {
        return this.colorType;
    }

    public Integer getId() {
        return this.id;
    }

    public boolean contains(Color color) {
        if (this.tuple != null) {
            for (Color c : this.tuple) {
                if (!c.contains(color)) continue;
                return true;
            }
            return false;
        }
        return this.equals(color);
    }

    public Color successor() {
        return this.colorType.successorTo(this, 1);
    }

    public Color predecessor() {
        return this.colorType.successorTo(this, -1);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Color)) {
            return false;
        }
        Color object = (Color)o;
        if (object.getColorName().equals("dot") && this.colorName.equals("dot")) {
            return true;
        }
        if (!object.getName().equals(this.getName())) {
            return false;
        }
        if (!object.colorType.getName().equals(this.colorType.getName())) {
            return false;
        }
        if (object.tuple == null && this.tuple != null) {
            return false;
        }
        if (this.tuple == null && object.tuple != null) {
            return false;
        }
        if (this.tuple == null && object.tuple == null) {
            return true;
        }
        if (this.tuple.size() != object.tuple.size()) {
            return false;
        }
        for (int i = 0; i < this.getTuple().size(); ++i) {
            if (this.getTuple().get(i).equals(object.tuple.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 37;
        if (this.tuple != null) {
            result = 31 * result + this.tuple.hashCode();
        }
        if (this.colorType != null) {
            result = 31 * result + this.colorType.hashCode();
        }
        if (this.colorName != null) {
            result = 31 * result + this.colorName.hashCode();
        }
        return result;
    }

    public String toString() {
        if (this.tuple != null) {
            StringBuilder out = new StringBuilder("(");
            for (Color color : this.tuple) {
                out.append(color.toString()).append(", ");
            }
            out = new StringBuilder(out.substring(0, out.length() - 2));
            out.append(")");
            return out.toString();
        }
        return this.colorName;
    }

    public Color deepCopy() {
        if (this.tuple == null) {
            return new Color(this.colorType.copy(), this.id, this.colorName);
        }
        Vector<Color> colors = new Vector<Color>();
        for (Color color : this.tuple) {
            colors.add(color.deepCopy());
        }
        return new Color(this.colorType.copy(), this.id, colors);
    }

    public Color getExprWithNewColorType(ColorType ct) {
        if (this.colorType.getName().equals(ct.getName()) || ct.contains(this)) {
            return new Color(ct, this.id, this.tuple, this.colorName);
        }
        return this;
    }
}

