/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io.queries;

import dk.aau.cs.TCTL.XMLParsing.QueryWrapper;
import dk.aau.cs.TCTL.XMLParsing.XMLCTLQueryParser;
import dk.aau.cs.TCTL.XMLParsing.XMLHyperLTLQueryParser;
import dk.aau.cs.TCTL.XMLParsing.XMLLTLQueryParser;
import dk.aau.cs.TCTL.visitors.RenameTemplateVisitor;
import dk.aau.cs.debug.Logger;
import dk.aau.cs.io.LoadedQueries;
import dk.aau.cs.io.queries.QueryLoader;
import dk.aau.cs.io.queries.TAPNQueryLoader;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.verification.SMCSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;

public class XMLQueryLoader
extends QueryLoader {
    private final File file;
    private final List<TAPNQuery.QueryCategory> queryCategories;
    private final ArrayList<QueryWrapper> faultyQueries = new ArrayList();

    public XMLQueryLoader(File file, TimedArcPetriNetNetwork network) {
        this(file, network, null);
    }

    public XMLQueryLoader(File file, TimedArcPetriNetNetwork network, List<TAPNQuery.QueryCategory> queryCategories) {
        super(network);
        this.file = file;
        this.queryCategories = queryCategories;
    }

    @Override
    protected ArrayList<TAPNQuery> getQueries() {
        Document doc;
        DocumentBuilder db;
        ArrayList<TAPNQuery> queries = new ArrayList<TAPNQuery>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.log(e);
            this.createDialogBox(e.getMessage(), "Parse Exception");
            return queries;
        }
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        try {
            doc = db.parse(this.file);
        }
        catch (IOException | IllegalArgumentException | SAXException e) {
            Logger.log(e);
            this.createDialogBox(e.getMessage(), "Parse Exception");
            return queries;
        }
        NodeList propList = doc.getElementsByTagName("property");
        int choice = -1;
        for (int i = 0; i < propList.getLength(); ++i) {
            boolean isHyperLTL;
            Node prop = propList.item(i);
            QueryWrapper queryWrapper = new QueryWrapper();
            this.faultyQueries.add(queryWrapper);
            TAPNLens lens = TAPAALGUI.getCurrentTab().getLens();
            boolean isTimed = lens != null && lens.isTimed() || this.network.isTimed();
            boolean isKnownGame = lens != null && lens.isGame();
            boolean isStochastic = lens != null && lens.isStochastic();
            boolean canBeCTL = isTimed || XMLQueryLoader.canBeCTL(prop);
            boolean canBeLTL = !isTimed && !isKnownGame && XMLQueryLoader.canBeLTL(prop);
            boolean canBeHyperLTL = !isTimed && !isKnownGame && XMLQueryLoader.canBeHyperLTL(prop);
            boolean hasSmcTag = TAPNQueryLoader.hasSmcTag(prop);
            boolean isSmc = isStochastic && hasSmcTag;
            int counter = 0;
            if (canBeCTL) {
                ++counter;
            }
            if (canBeLTL) {
                ++counter;
            }
            if (canBeHyperLTL) {
                ++counter;
            }
            if (counter > 1 && choice == -1 && this.queryCategories == null && !isSmc) {
                choice = JOptionPane.showOptionDialog(TAPAALGUI.getApp(), "There were some queries that can be classified as CTL, LTL or HyperLTL. \nHow do you want to import them?", "Choose query category", 1, 3, null, new Object[]{"Import all as CTL", "Import all as LTL", "Import all as HyperLTL", "Cancel"}, 0);
            } else if (!(canBeCTL || canBeLTL || canBeHyperLTL)) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "One or more queries do not have the correct format.");
            }
            if (choice == 3) {
                return null;
            }
            boolean isCTL = canBeCTL && counter == 1 || counter > 1 && choice == 0;
            boolean isLTL = canBeLTL && counter == 1 || counter > 1 && choice == 1;
            boolean bl = isHyperLTL = canBeHyperLTL && counter == 1 || counter > 1 && choice == 2;
            if (this.queryCategories != null && this.queryCategories.size() > i) {
                if (this.queryCategories.get(i) == TAPNQuery.QueryCategory.CTL) {
                    isCTL = true;
                } else if (this.queryCategories.get(i) == TAPNQuery.QueryCategory.LTL) {
                    isLTL = true;
                } else if (this.queryCategories.get(i) == TAPNQuery.QueryCategory.HyperLTL) {
                    isHyperLTL = true;
                } else if (this.queryCategories.get(i) == TAPNQuery.QueryCategory.SMC) {
                    isSmc = true;
                }
            }
            if (isCTL && !isSmc) {
                if (!XMLCTLQueryParser.parse(prop, queryWrapper)) {
                    queries.add(null);
                    continue;
                }
            } else if (isLTL) {
                if (!XMLLTLQueryParser.parse(prop, queryWrapper)) {
                    queries.add(null);
                    continue;
                }
            } else if (isHyperLTL) {
                if (!XMLHyperLTLQueryParser.parse(prop, queryWrapper)) {
                    queries.add(null);
                    continue;
                }
            } else if (isSmc && !XMLLTLQueryParser.parse(prop, queryWrapper)) {
                queries.add(null);
                continue;
            }
            TAPNQuery query = new TAPNQuery(queryWrapper.getName(), 9999, queryWrapper.getProp(), TAPNQuery.TraceOption.NONE, TAPNQuery.SearchOption.HEURISTIC, ReductionOption.VerifyPN, true, false, true, true, true, true, TAPNQuery.HashTableSize.MB_16, TAPNQuery.ExtrapolationOption.AUTOMATIC, new InclusionPlaces(), this.network.isColored());
            RenameTemplateVisitor rt = new RenameTemplateVisitor("", this.network.activeTemplates().get(0).name());
            query.setCategory(TAPNQueryLoader.detectCategory(queryWrapper.getProp(), isCTL, isLTL, isHyperLTL, isSmc));
            if (query.getCategory() == TAPNQuery.QueryCategory.CTL || query.getCategory() == TAPNQuery.QueryCategory.LTL) {
                query.setSearchOption(TAPNQuery.SearchOption.DFS);
                query.setUseReduction(true);
            } else if (query.getCategory() == TAPNQuery.QueryCategory.HyperLTL) {
                query.setSearchOption(TAPNQuery.SearchOption.DFS);
                query.setTraceList(queryWrapper.getTraceList());
                query.setUseStubbornReduction(false);
                query.setUseReduction(false);
            } else if (query.getCategory() == TAPNQuery.QueryCategory.SMC) {
                query.setReductionOption(ReductionOption.VerifyDTAPN);
                SMCSettings smcSettings = SMCSettings.Default();
                if (hasSmcTag) {
                    Element smcTag = (Element)((Element)prop).getElementsByTagName("smc").item(0);
                    smcSettings = TAPNQueryLoader.parseSmcSettings(smcTag);
                }
                query.setSmcSettings(smcSettings);
            }
            query.getProperty().accept(rt, null);
            queries.add(query);
        }
        return queries;
    }

    public static boolean canBeCTL(Node prop) {
        NodeList children = prop.getChildNodes();
        boolean correctQuantifiers = false;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("formula")) continue;
            correctQuantifiers = XMLQueryLoader.checkQuantifiers(child);
        }
        return correctQuantifiers;
    }

    private static boolean checkQuantifiers(Node prop) {
        NodeList children = prop.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node parent;
            Node child = children.item(i);
            if ((child.getNodeName().equals("finally") || child.getNodeName().equals("globally") || child.getNodeName().equals("next") || child.getNodeName().equals("until")) && ((parent = child.getParentNode()) == null || !parent.getNodeName().equals("all-paths") && !parent.getNodeName().equals("exists-path"))) {
                return false;
            }
            if (XMLQueryLoader.checkQuantifiers(child)) continue;
            return false;
        }
        return true;
    }

    public static boolean canBeHyperLTL(Node prop) {
        NodeList children = prop.getChildNodes();
        int hyperLTLNodesCount = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ((hyperLTLNodesCount += XMLQueryLoader.countHyperLTLNodes(child)) <= 0) continue;
            return true;
        }
        return hyperLTLNodesCount > 0;
    }

    public static int countHyperLTLNodes(Node prop) {
        NodeList children = prop.getChildNodes();
        int count = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("path-scope")) {
                return 1;
            }
            if ((child.getNodeName().equals("exists-path") || child.getNodeName().equals("all-paths")) && child.getAttributes().getLength() > 0) {
                return 1;
            }
            count += XMLQueryLoader.countHyperLTLNodes(child);
        }
        return count;
    }

    public static boolean canBeLTL(Node prop) {
        NodeList children = prop.getChildNodes();
        int counter = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("formula")) continue;
            counter += XMLQueryLoader.countSupportedPaths(child);
        }
        return counter == 1;
    }

    private static int countSupportedPaths(Node prop) {
        NodeList children = prop.getChildNodes();
        int counter = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("all-paths") || child.getNodeName().equals("exists-path")) {
                ++counter;
            } else if (child.getNodeName().equals("deadlock")) {
                return 100;
            }
            counter += XMLQueryLoader.countSupportedPaths(child);
        }
        return counter;
    }

    public static void importQueries(File file, TimedArcPetriNetNetwork network, PetriNetTab tab) {
        XMLQueryLoader loader = new XMLQueryLoader(file, network);
        loader.showErrorMessage = false;
        LoadedQueries loadedQueries = loader.parseQueries();
        if (loadedQueries == null) {
            return;
        }
        block0: for (TAPNQuery query : loadedQueries.getQueries()) {
            tab.addQuery(query);
            for (QueryWrapper q : loader.faultyQueries) {
                if (!q.getName().equals(query.getName())) continue;
                loader.faultyQueries.remove(q);
                continue block0;
            }
        }
        loader.createErrorDialog(loader);
    }

    private void createErrorDialog(XMLQueryLoader loader) {
        if (loader.faultyQueries.size() > 0) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("We can parse and import only the reachability cardinality and reachability deadlock XML queries.");
            errorMessage.append(System.lineSeparator());
            for (QueryWrapper q : loader.faultyQueries) {
                errorMessage.append(System.lineSeparator());
                errorMessage.append(q.getNameAndException());
                if (!q.hasException() && loader.queryUsingNonexistentPlaceFound) {
                    errorMessage.append("  Reason: place not found in model");
                    continue;
                }
                if (q.hasException() || !loader.queryUsingNonexistentTransitionFound) continue;
                errorMessage.append("  Reason: transition not found in model");
            }
            this.createDialogBox(errorMessage.toString(), "Error Parsing Queries");
        }
    }

    private void createDialogBox(String text, String header) {
        JOptionPane.showMessageDialog(TAPAALGUI.getApp(), text, header, 0);
    }
}

