/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io.queries;

import dk.aau.cs.TCTL.SUMOParsing.ParseException;
import dk.aau.cs.TCTL.SUMOParsing.SUMOQueryParser;
import dk.aau.cs.TCTL.SUMOParsing.TokenMgrError;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.visitors.RenameTemplateVisitor;
import dk.aau.cs.debug.Logger;
import dk.aau.cs.io.LoadedQueries;
import dk.aau.cs.io.queries.QueryLoader;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.translations.ReductionOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.MessengerImpl;
import pipe.gui.petrinet.PetriNetTab;

public class SUMOQueryLoader
extends QueryLoader {
    private final File file;

    public SUMOQueryLoader(File file, TimedArcPetriNetNetwork network) {
        super(network);
        this.file = file;
    }

    @Override
    protected ArrayList<TAPNQuery> getQueries() {
        String[] textQueries;
        ArrayList<TAPNQuery> queries = new ArrayList<TAPNQuery>();
        Pattern p = Pattern.compile("Property\\s*([^\\n]*)[^:]*:(.*)", 32);
        byte[] encoded = null;
        try {
            encoded = Files.readAllBytes(this.file.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String queriesString = new String(encoded);
        for (String queryAndNameString : textQueries = queriesString.split("\\n\\s*end\\.")) {
            TCTLAbstractProperty property;
            Matcher m = p.matcher(queryAndNameString);
            if (!m.find() && this.firstQueryParsingWarning) {
                queries.add(null);
                continue;
            }
            String name = m.group(1).trim();
            String queryString = m.group(2).trim();
            try {
                property = SUMOQueryParser.parse(queryString);
            }
            catch (ParseException | TokenMgrError e) {
                Logger.log(e);
                queries.add(null);
                continue;
            }
            TAPNQuery query = new TAPNQuery(name, 9999, property, TAPNQuery.TraceOption.NONE, TAPNQuery.SearchOption.HEURISTIC, ReductionOption.VerifyPN, true, false, true, true, true, true, TAPNQuery.HashTableSize.MB_16, TAPNQuery.ExtrapolationOption.AUTOMATIC, new InclusionPlaces(), this.network.isColored());
            RenameTemplateVisitor rt = new RenameTemplateVisitor("", this.network.activeTemplates().get(0).name());
            query.getProperty().accept(rt, null);
            queries.add(query);
        }
        return queries;
    }

    public static void importQueries(File file, TimedArcPetriNetNetwork network, PetriNetTab tab) {
        SUMOQueryLoader loader = new SUMOQueryLoader(file, network);
        LoadedQueries loadedQueries = loader.parseQueries();
        if (loadedQueries.getMessages().size() != 0) {
            Object message = "While loading the net we found one or more warnings: \n\n";
            for (String s : loadedQueries.getMessages()) {
                message = (String)message + s + "\n\n";
            }
            new MessengerImpl().displayInfoMessage((String)message, "Warning");
        }
        for (TAPNQuery query : loadedQueries.getQueries()) {
            tab.addQuery(query);
        }
    }
}

