/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io.queries;

import dk.aau.cs.TCTL.visitors.VerifyPlaceNamesVisitor;
import dk.aau.cs.TCTL.visitors.VerifyTransitionNamesVisitor;
import dk.aau.cs.io.LoadedQueries;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.tapaal.gui.petrinet.verification.TAPNQuery;

public abstract class QueryLoader {
    protected static final String ERROR_PARSING_QUERY_MESSAGE = "TAPAAL encountered an error trying to parse one or more of the queries in the model.\n\nThe queries that could not be parsed will not show up in the query list.";
    protected boolean firstQueryParsingWarning = true;
    boolean queryUsingNonexistentPlaceFound = false;
    boolean queryUsingNonexistentTransitionFound = false;
    protected boolean showErrorMessage = true;
    protected final Collection<String> messages = new ArrayList<String>(10);
    protected final TimedArcPetriNetNetwork network;

    public QueryLoader(TimedArcPetriNetNetwork network) {
        this.network = network;
    }

    public LoadedQueries parseQueries() {
        ArrayList<TAPNQuery> queries = this.getQueries();
        if (queries == null) {
            return null;
        }
        ArrayList<Tuple<String, String>> templatePlaceNames = this.getPlaceNames(this.network);
        ArrayList<Tuple<String, String>> templateTransitionNames = this.getTransitionNames(this.network);
        Iterator<TAPNQuery> iterator = queries.iterator();
        while (iterator.hasNext()) {
            TAPNQuery query = iterator.next();
            if (query == null) {
                iterator.remove();
                continue;
            }
            if (!this.doesPlacesUsedInQueryExist(query, templatePlaceNames)) {
                this.queryUsingNonexistentPlaceFound = true;
                iterator.remove();
                continue;
            }
            if (this.doesTransitionsUsedInQueryExist(query, templateTransitionNames)) continue;
            this.queryUsingNonexistentTransitionFound = true;
            iterator.remove();
        }
        if (this.queryUsingNonexistentPlaceFound && this.firstQueryParsingWarning && this.showErrorMessage) {
            this.messages.add(ERROR_PARSING_QUERY_MESSAGE);
            this.firstQueryParsingWarning = false;
        } else if (this.queryUsingNonexistentTransitionFound && this.firstQueryParsingWarning && this.showErrorMessage) {
            this.messages.add(ERROR_PARSING_QUERY_MESSAGE);
            this.firstQueryParsingWarning = false;
        }
        return new LoadedQueries(queries, this.messages);
    }

    private ArrayList<Tuple<String, String>> getPlaceNames(TimedArcPetriNetNetwork network) {
        ArrayList<Tuple<String, String>> templatePlaceNames = new ArrayList<Tuple<String, String>>();
        for (TimedArcPetriNet timedArcPetriNet : network.allTemplates()) {
            for (TimedPlace p : timedArcPetriNet.places()) {
                templatePlaceNames.add(new Tuple<String, String>(timedArcPetriNet.name(), p.name()));
            }
        }
        for (TimedPlace timedPlace : network.sharedPlaces()) {
            templatePlaceNames.add(new Tuple<String, String>("", timedPlace.name()));
        }
        return templatePlaceNames;
    }

    private ArrayList<Tuple<String, String>> getTransitionNames(TimedArcPetriNetNetwork network) {
        ArrayList<Tuple<String, String>> templateTransitionNames = new ArrayList<Tuple<String, String>>();
        for (TimedArcPetriNet tapn : network.allTemplates()) {
            for (TimedTransition t : tapn.transitions()) {
                templateTransitionNames.add(new Tuple<String, String>(tapn.name(), t.name()));
            }
        }
        for (SharedTransition t : network.sharedTransitions()) {
            templateTransitionNames.add(new Tuple<String, String>("", t.name()));
        }
        return templateTransitionNames;
    }

    private boolean doesPlacesUsedInQueryExist(TAPNQuery query, ArrayList<Tuple<String, String>> templatePlaceNames) {
        VerifyPlaceNamesVisitor nameChecker = new VerifyPlaceNamesVisitor(templatePlaceNames);
        VerifyPlaceNamesVisitor.Context c = nameChecker.verifyPlaceNames(query.getProperty());
        return c.getResult();
    }

    private boolean doesTransitionsUsedInQueryExist(TAPNQuery query, ArrayList<Tuple<String, String>> templateTransitionNames) {
        VerifyTransitionNamesVisitor nameChecker = new VerifyTransitionNamesVisitor(templateTransitionNames);
        VerifyTransitionNamesVisitor.Context c = nameChecker.verifyTransitionNames(query.getProperty());
        return c.getResult();
    }

    protected abstract ArrayList<TAPNQuery> getQueries();
}

