/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io.batchProcessing;

import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.verification.batchProcessing.BatchProcessingVerificationResult;
import java.io.File;
import java.io.PrintStream;
import net.tapaal.gui.petrinet.verification.TAPNQuery;

public class BatchProcessingResultsExporter {
    private static final String name_verifyTAPN = "A: TAPAAL Continuous Engine";
    private static final String name_verifyTAPN_discreteInclusion = "B: TAPAAL Continuous Engine w. Discrete Inclusion";
    private static final String name_verifyTAPNDiscreteVerificationTimeDartPTrie = "C: TAPAAL Discrete Engine w. Time Darts and PTrie";
    private static final String name_verifyTAPNDiscreteVerificationTimeDart = "D: TAPAAL Discrete Engine w. Time Darts";
    private static final String name_verifyTAPNDiscreteVerificationPTrie = "E: TAPAAL Discrete Engine Engine w. PTries";
    private static final String name_verifyTAPNDiscreteVerificationNone = "F: TAPAAL Discrete Engine w. no Optimizations";
    private static final String name_COMBI = "G: UPPAAL: Optimized Broadcast Reduction";
    private static final String name_STANDARD = "H: UPPAAL: Standard Reduction";
    private static final String name_OPTIMIZEDSTANDARD = "I: UPPAAL: Optimised Standard Reduction";
    private static final String name_BROADCAST = "J: UPPAAL: Broadcast Reduction";
    private static final String name_BROADCASTDEG2 = "K: UPPAAL: Broadcast Degree 2 Reduction";
    private static final String name_UNTIMED = "L: TAPAAL Untimed Engine";
    private static final String name_UNTIMEDAPPROX = "M: TAPAAL Untimed Engine, State-Equations Check Only";
    private static final String name_UNTIMEDREDUCE = "N: TAPAAL Untimed engine w. Net Reductions";
    private static final String name_BFS = "Breadth First Search";
    private static final String name_DFS = "Depth First Search";
    private static final String name_RandomDFS = "Random Depth First Search";
    private static final String name_NONE_APPROXIMATION = "None";
    private static final String name_OVER_APPROXIMATION = "Over-approximation";
    private static final String name_UNDER_APPROXIMATION = "Under-approximation";
    private static final String DELIMITER = ";";

    public void exportToCSV(Iterable<BatchProcessingVerificationResult> results, File outputFile) throws Exception {
        PrintStream writer = new PrintStream(outputFile);
        this.exportToCSV(results, writer);
    }

    public void exportToCSV(Iterable<BatchProcessingVerificationResult> results, PrintStream outputStream) throws Exception {
        outputStream.println("Model;Query;Result;Verification Time;Memory Usage;Discovered States;Explored States;Stored States;Query Property;Extra Tokens;Verification Method;Symmetry;Search Order;Approximation Method;Approximation Constant");
        for (BatchProcessingVerificationResult result : results) {
            TAPNQuery query = result.query();
            StringBuilder s = new StringBuilder();
            s.append(result.modelFile());
            s.append(DELIMITER);
            s.append(query != null ? query.getName() : "");
            s.append(DELIMITER);
            s.append(result.verificationResult());
            s.append(DELIMITER);
            s.append((double)result.verificationTimeInMs() / 1000.0 + " s");
            s.append(DELIMITER);
            s.append(result.verificationMemory());
            s.append(DELIMITER);
            s.append(result.hasStats() ? Long.valueOf(result.stats().discoveredStates()) : "");
            s.append(DELIMITER);
            s.append(result.hasStats() ? Long.valueOf(result.stats().exploredStates()) : "");
            s.append(DELIMITER);
            s.append(result.hasStats() ? Long.valueOf(result.stats().storedStates()) : "");
            s.append(DELIMITER);
            s.append(query != null ? query.getProperty().toString() : "");
            s.append(DELIMITER);
            s.append(query != null ? Integer.valueOf(query.getCapacity()) : "");
            s.append(DELIMITER);
            s.append(query != null ? this.getSearchOrder(query) : "");
            s.append(DELIMITER);
            s.append(query != null ? (query.useSymmetry() ? "Yes" : "No") : "");
            s.append(DELIMITER);
            s.append(query != null ? this.getVerificationMethod(query) : "");
            s.append(DELIMITER);
            s.append(query != null ? this.getApproximationMethod(query) : "");
            s.append(DELIMITER);
            s.append(query != null ? Integer.valueOf(query.approximationDenominator()) : "");
            outputStream.println(s);
        }
    }

    private String getVerificationMethod(TAPNQuery query) {
        TAPNQuery.SearchOption search = query.getSearchOption();
        if (search == TAPNQuery.SearchOption.DFS) {
            return name_DFS;
        }
        if (search == TAPNQuery.SearchOption.RANDOM) {
            return name_RandomDFS;
        }
        return name_BFS;
    }

    private String getApproximationMethod(TAPNQuery query) {
        if (query.isOverApproximationEnabled()) {
            return name_OVER_APPROXIMATION;
        }
        if (query.isUnderApproximationEnabled()) {
            return name_UNDER_APPROXIMATION;
        }
        return name_NONE_APPROXIMATION;
    }

    private Object getSearchOrder(TAPNQuery query) {
        ReductionOption reduction = query.getReductionOption();
        if (reduction == ReductionOption.COMBI) {
            return name_COMBI;
        }
        if (reduction == ReductionOption.STANDARD) {
            return name_STANDARD;
        }
        if (reduction == ReductionOption.OPTIMIZEDSTANDARD) {
            return name_OPTIMIZEDSTANDARD;
        }
        if (reduction == ReductionOption.DEGREE2BROADCAST) {
            return name_BROADCASTDEG2;
        }
        if (reduction == ReductionOption.VerifyTAPN) {
            if (query.discreteInclusion()) {
                return name_verifyTAPN_discreteInclusion;
            }
            return name_verifyTAPN;
        }
        if (reduction == ReductionOption.VerifyDTAPN) {
            if (query.useTimeDarts() && query.usePTrie()) {
                return name_verifyTAPNDiscreteVerificationTimeDartPTrie;
            }
            if (query.useTimeDarts()) {
                return name_verifyTAPNDiscreteVerificationTimeDart;
            }
            if (query.usePTrie()) {
                return name_verifyTAPNDiscreteVerificationPTrie;
            }
            return name_verifyTAPNDiscreteVerificationNone;
        }
        if (reduction == ReductionOption.VerifyPN) {
            return name_UNTIMED;
        }
        if (reduction == ReductionOption.VerifyPNApprox) {
            return name_UNTIMEDAPPROX;
        }
        if (reduction == ReductionOption.VerifyPNReduce) {
            return name_UNTIMEDREDUCE;
        }
        return name_BROADCAST;
    }
}

