/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io;

import dk.aau.cs.TCTL.visitors.CTLQueryVisitor;
import dk.aau.cs.TCTL.visitors.HyperLTLQueryVisitor;
import dk.aau.cs.TCTL.visitors.LTLQueryVisitor;
import dk.aau.cs.TCTL.visitors.SMCQueryVisitor;
import dk.aau.cs.io.NetWriter;
import dk.aau.cs.io.writeTACPN;
import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.util.Require;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.AnnotationNote;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;

public class TimedArcPetriNetNetworkWriter
implements NetWriter {
    private final Iterable<Template> templates;
    private final Iterable<TAPNQuery> queries;
    private final Iterable<Constant> constants;
    private final TimedArcPetriNetNetwork network;
    private final writeTACPN writeTACPN;
    private boolean secondTransport = false;
    private int transporCountID = 0;
    private final TAPNLens lens;
    private boolean saveConstantNames;

    public TimedArcPetriNetNetworkWriter(TimedArcPetriNetNetwork network, Iterable<Template> templates, Iterable<TAPNQuery> queries, Iterable<Constant> constants) {
        this.network = network;
        this.templates = templates;
        this.queries = queries;
        this.constants = constants;
        this.writeTACPN = new writeTACPN(network);
        this.lens = TAPNLens.Default;
    }

    public TimedArcPetriNetNetworkWriter(TimedArcPetriNetNetwork network, Iterable<Template> templates, Iterable<TAPNQuery> queries, Iterable<Constant> constants, TAPNLens lens) {
        this.network = network;
        this.templates = templates;
        this.queries = queries;
        this.constants = constants;
        this.writeTACPN = new writeTACPN(network);
        this.lens = lens;
    }

    @Override
    public ByteArrayOutputStream savePNML() throws ParserConfigurationException, DOMException, TransformerException {
        Document document = null;
        Transformer transformer = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        document = builder.newDocument();
        Element pnmlRootNode = document.createElement("pnml");
        document.appendChild(pnmlRootNode);
        Attr pnmlAttr = document.createAttribute("xmlns");
        pnmlAttr.setValue("http://www.informatik.hu-berlin.de/top/pnml/ptNetb");
        pnmlRootNode.setAttributeNode(pnmlAttr);
        this.writeTACPN.appendDeclarations(document, pnmlRootNode);
        this.appendSharedPlaces(document, pnmlRootNode);
        this.appendSharedTransitions(document, pnmlRootNode);
        this.appendConstants(document, pnmlRootNode);
        this.appendTemplates(document, pnmlRootNode);
        this.appendQueries(document, pnmlRootNode);
        this.appendFeature(document, pnmlRootNode);
        document.normalize();
        transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
        return os;
    }

    @Override
    public void savePNML(File file) throws IOException, ParserConfigurationException, DOMException, TransformerException {
        this.savePNML(file, true);
    }

    public void savePNML(File file, boolean saveConstantNames) throws IOException, ParserConfigurationException, DOMException, TransformerException {
        this.saveConstantNames = saveConstantNames;
        Require.that(file != null, "Error: file to save to was null");
        try {
            ByteArrayOutputStream os = this.savePNML();
            FileOutputStream fs = new FileOutputStream(file);
            fs.write(os.toByteArray());
            fs.close();
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfigurationException thrown in savePNML() : dataLayerWriter Class : dataLayer Package: filename=\"");
        }
        catch (DOMException e) {
            System.out.println("DOMException thrown in savePNML() : dataLayerWriter Class : dataLayer Package: filename=\"" + file.getCanonicalPath() + "\" transformer=\"");
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            System.out.println("TransformerConfigurationException thrown in savePNML() : dataLayerWriter Class : dataLayer Package: filename=\"" + file.getCanonicalPath() + "\" transformer=\"");
        }
        catch (TransformerException e) {
            System.out.println("TransformerException thrown in savePNML() : dataLayerWriter Class : dataLayer Package: filename=\"" + file.getCanonicalPath() + "\"" + String.valueOf(e));
        }
    }

    private void appendFeature(Document document, Element root) {
        String isTimed = "true";
        String isGame = "true";
        String isColored = "true";
        String isStochastic = "true";
        if (!this.lens.isTimed()) {
            isTimed = "false";
        }
        if (!this.lens.isGame()) {
            isGame = "false";
        }
        if (!this.lens.isColored()) {
            isColored = "false";
        }
        if (!this.lens.isStochastic()) {
            isStochastic = "false";
        }
        root.appendChild(this.createFeatureElement(isTimed, isGame, isColored, isStochastic, document));
    }

    private Element createFeatureElement(String isTimed, String isGame, String isColored, String isStochastic, Document document) {
        Require.that(document != null, "Error: document was null");
        Element feature = document.createElement("feature");
        feature.setAttribute("isTimed", isTimed);
        feature.setAttribute("isGame", isGame);
        feature.setAttribute("isColored", isColored);
        feature.setAttribute("isStochastic", isStochastic);
        return feature;
    }

    private void appendSharedPlaces(Document document, Element root) {
        for (SharedPlace place : this.network.sharedPlaces()) {
            Element element = document.createElement("shared-place");
            element.setAttribute("invariant", place.invariant().toString());
            element.setAttribute("name", place.name());
            element.setAttribute("initialMarking", String.valueOf(place.numberOfTokens()));
            this.createColoredInvariants(place, document, element);
            this.writeTACPN.appendColoredPlaceDependencies(place, document, element);
            root.appendChild(element);
        }
    }

    private void appendSharedTransitions(Document document, Element root) {
        for (SharedTransition transition : this.network.sharedTransitions()) {
            Element element = document.createElement("shared-transition");
            element.setAttribute("name", transition.name());
            element.setAttribute("urgent", transition.isUrgent() ? "true" : "false");
            element.setAttribute("player", transition.isUncontrollable() ? "1" : "0");
            element.setAttribute("weight", transition.getWeight().nameForSaving(this.saveConstantNames));
            element.setAttribute("firingMode", transition.getFiringMode().toString());
            transition.getDistribution().writeToXml(element);
            root.appendChild(element);
        }
    }

    private void appendConstants(Document document, Element root) {
        for (Constant constant : this.constants) {
            Element elem = this.createConstantElement(constant, document);
            root.appendChild(elem);
        }
    }

    private Element createConstantElement(Constant constant, Document document) {
        Require.that(constant != null, "Error: constant was null");
        Require.that(document != null, "Error: document was null");
        Element constantElement = document.createElement("constant");
        constantElement.setAttribute("name", constant.name());
        constantElement.setAttribute("value", String.valueOf(constant.value()));
        return constantElement;
    }

    private void appendTemplates(Document document, Element root) {
        for (Template tapn : this.templates) {
            DataLayer guiModel = tapn.guiModel();
            Element NET = document.createElement("net");
            root.appendChild(NET);
            Attr netAttrId = document.createAttribute("id");
            netAttrId.setValue(tapn.model().name());
            NET.setAttributeNode(netAttrId);
            Attr netAttrActive = document.createAttribute("active");
            netAttrActive.setValue("" + tapn.isActive());
            NET.setAttributeNode(netAttrActive);
            Attr netAttrType = document.createAttribute("type");
            netAttrType.setValue("P/T net");
            NET.setAttributeNode(netAttrType);
            this.appendAnnotationNotes(document, guiModel, NET);
            this.appendPlaces(document, guiModel, NET);
            this.appendTransitions(document, guiModel, NET);
            this.appendArcs(document, guiModel, NET);
        }
    }

    private void appendAnnotationNotes(Document document, DataLayer guiModel, Element NET) {
        AnnotationNote[] labels;
        for (AnnotationNote label : labels = guiModel.getLabels()) {
            NET.appendChild(this.createAnnotationNoteElement(label, document));
        }
    }

    private void appendPlaces(Document document, DataLayer guiModel, Element NET) {
        Place[] places;
        for (Place place : places = guiModel.getPlaces()) {
            NET.appendChild(this.createPlaceElement((TimedPlaceComponent)place, guiModel, document));
        }
    }

    private void appendTransitions(Document document, DataLayer guiModel, Element NET) {
        Transition[] transitions;
        for (Transition transition : transitions = guiModel.getTransitions()) {
            NET.appendChild(this.createTransitionElement((TimedTransitionComponent)transition, document));
        }
    }

    private void appendArcs(Document document, DataLayer guiModel, Element NET) {
        Arc[] arcs = guiModel.getArcs();
        for (int i = 0; i < arcs.length; ++i) {
            Element newArc = this.createArcElement(arcs[i], guiModel, document);
            int arcPoints = arcs[i].getArcPath().getArcPathDetails().length;
            String[][] point = arcs[i].getArcPath().getArcPathDetails();
            for (int j = 0; j < arcPoints; ++j) {
                newArc.appendChild(this.createArcPoint(point[j][0], point[j][1], point[j][2], document, j));
            }
            NET.appendChild(newArc);
        }
    }

    private void appendQueries(Document document, Element root) {
        for (TAPNQuery query : this.queries) {
            Element newQuery = query.getCategory() == TAPNQuery.QueryCategory.LTL ? this.createLTLQueryElement(query, document) : (query.getCategory() == TAPNQuery.QueryCategory.HyperLTL ? this.createHyperLTLQueryElement(query, document) : (query.getCategory() == TAPNQuery.QueryCategory.SMC ? this.createSMCQueryElement(query, document) : this.createCTLQueryElement(query, document)));
            root.appendChild(newQuery);
        }
    }

    private Element createCTLQueryElement(TAPNQuery query, Document document) {
        Require.that(query != null, "Error: query was null");
        Require.that(document != null, "Error: document was null");
        Element queryElement = document.createElement("query");
        CTLQueryVisitor ctlQueryVisitor = new CTLQueryVisitor();
        ctlQueryVisitor.buildXMLQuery(query.getProperty(), query.getName(), false);
        Node queryFormula = this.XMLQueryStringToElement(ctlQueryVisitor.getXMLQuery().toString());
        queryElement.appendChild(document.importNode(queryFormula, true));
        queryElement.setAttribute("name", query.getName());
        queryElement.setAttribute("type", query.getCategory().toString());
        queryElement.setAttribute("capacity", "" + query.getCapacity());
        queryElement.setAttribute("traceOption", String.valueOf((Object)query.getTraceOption()));
        queryElement.setAttribute("searchOption", String.valueOf((Object)query.getSearchOption()));
        queryElement.setAttribute("hashTableSize", String.valueOf((Object)query.getHashTableSize()));
        queryElement.setAttribute("extrapolationOption", String.valueOf((Object)query.getExtrapolationOption()));
        queryElement.setAttribute("reductionOption", String.valueOf((Object)query.getReductionOption()));
        queryElement.setAttribute("coloredReduction", "" + query.useColoredReduction());
        queryElement.setAttribute("symmetry", "" + query.useSymmetry());
        queryElement.setAttribute("gcd", "" + query.useGCD());
        queryElement.setAttribute("timeDarts", "" + query.useTimeDarts());
        queryElement.setAttribute("pTrie", "" + query.usePTrie());
        queryElement.setAttribute("discreteInclusion", String.valueOf(query.discreteInclusion()));
        queryElement.setAttribute("active", "" + query.isActive());
        queryElement.setAttribute("inclusionPlaces", this.getInclusionPlacesString(query));
        queryElement.setAttribute("overApproximation", "" + query.useOverApproximation());
        queryElement.setAttribute("reduction", "" + query.useReduction());
        queryElement.setAttribute("enableOverApproximation", "" + query.isOverApproximationEnabled());
        queryElement.setAttribute("enableUnderApproximation", "" + query.isUnderApproximationEnabled());
        queryElement.setAttribute("approximationDenominator", "" + query.approximationDenominator());
        queryElement.setAttribute("algorithmOption", String.valueOf((Object)query.getAlgorithmOption()));
        queryElement.setAttribute("useSiphonTrapAnalysis", "" + query.isSiphontrapEnabled());
        queryElement.setAttribute("useQueryReduction", "" + query.isQueryReductionEnabled());
        queryElement.setAttribute("useStubbornReduction", "" + query.isStubbornReductionEnabled());
        queryElement.setAttribute("useTarOption", "" + query.isTarOptionEnabled());
        queryElement.setAttribute("useTarjan", "" + query.isTarjan());
        queryElement.setAttribute("partitioning", "" + query.usePartitioning());
        queryElement.setAttribute("colorFixpoint", "" + query.useColorFixpoint());
        queryElement.setAttribute("symmetricVars", "" + query.useSymmetricVars());
        queryElement.setAttribute("useExplicitSearch", "" + query.useExplicitSearch());
        return queryElement;
    }

    private Element createHyperLTLQueryElement(TAPNQuery query, Document document) {
        Require.that(query != null, "Error: query was null");
        Require.that(document != null, "Error: document was null");
        Element queryElement = document.createElement("query");
        Node queryFormula = this.XMLQueryStringToElement(new HyperLTLQueryVisitor().getXMLQueryFor(query.getProperty(), query.getName()));
        queryElement.appendChild(document.importNode(queryFormula, true));
        String traces = String.join((CharSequence)",", query.getTraceList());
        queryElement.setAttribute("name", query.getName());
        queryElement.setAttribute("type", query.getCategory().toString());
        queryElement.setAttribute("traces", traces);
        queryElement.setAttribute("capacity", "" + query.getCapacity());
        queryElement.setAttribute("traceOption", String.valueOf((Object)query.getTraceOption()));
        queryElement.setAttribute("searchOption", String.valueOf((Object)query.getSearchOption()));
        queryElement.setAttribute("hashTableSize", String.valueOf((Object)query.getHashTableSize()));
        queryElement.setAttribute("extrapolationOption", String.valueOf((Object)query.getExtrapolationOption()));
        queryElement.setAttribute("reductionOption", String.valueOf((Object)query.getReductionOption()));
        queryElement.setAttribute("symmetry", "" + query.useSymmetry());
        queryElement.setAttribute("gcd", "" + query.useGCD());
        queryElement.setAttribute("timeDarts", "" + query.useTimeDarts());
        queryElement.setAttribute("pTrie", "" + query.usePTrie());
        queryElement.setAttribute("discreteInclusion", String.valueOf(query.discreteInclusion()));
        queryElement.setAttribute("active", "" + query.isActive());
        queryElement.setAttribute("inclusionPlaces", this.getInclusionPlacesString(query));
        queryElement.setAttribute("overApproximation", "" + query.useOverApproximation());
        queryElement.setAttribute("reduction", "" + query.useReduction());
        queryElement.setAttribute("enableOverApproximation", "" + query.isOverApproximationEnabled());
        queryElement.setAttribute("enableUnderApproximation", "" + query.isUnderApproximationEnabled());
        queryElement.setAttribute("approximationDenominator", "" + query.approximationDenominator());
        queryElement.setAttribute("algorithmOption", String.valueOf((Object)query.getAlgorithmOption()));
        queryElement.setAttribute("useSiphonTrapAnalysis", "" + query.isSiphontrapEnabled());
        queryElement.setAttribute("useQueryReduction", "" + query.isQueryReductionEnabled());
        queryElement.setAttribute("useStubbornReduction", "" + query.isStubbornReductionEnabled());
        queryElement.setAttribute("useTarOption", "" + query.isTarOptionEnabled());
        queryElement.setAttribute("useTarjan", "" + query.isTarjan());
        return queryElement;
    }

    private Element createLTLQueryElement(TAPNQuery query, Document document) {
        Require.that(query != null, "Error: query was null");
        Require.that(document != null, "Error: document was null");
        Element queryElement = document.createElement("query");
        LTLQueryVisitor ltlQueryVisitor = new LTLQueryVisitor();
        ltlQueryVisitor.buildXMLQuery(query.getProperty(), query.getName());
        Node queryFormula = this.XMLQueryStringToElement(ltlQueryVisitor.getXMLQuery().toString());
        queryElement.appendChild(document.importNode(queryFormula, true));
        queryElement.setAttribute("name", query.getName());
        queryElement.setAttribute("type", query.getCategory().toString());
        queryElement.setAttribute("capacity", "" + query.getCapacity());
        queryElement.setAttribute("traceOption", String.valueOf((Object)query.getTraceOption()));
        queryElement.setAttribute("searchOption", String.valueOf((Object)query.getSearchOption()));
        queryElement.setAttribute("hashTableSize", String.valueOf((Object)query.getHashTableSize()));
        queryElement.setAttribute("extrapolationOption", String.valueOf((Object)query.getExtrapolationOption()));
        queryElement.setAttribute("reductionOption", String.valueOf((Object)query.getReductionOption()));
        queryElement.setAttribute("symmetry", "" + query.useSymmetry());
        queryElement.setAttribute("gcd", "" + query.useGCD());
        queryElement.setAttribute("timeDarts", "" + query.useTimeDarts());
        queryElement.setAttribute("pTrie", "" + query.usePTrie());
        queryElement.setAttribute("discreteInclusion", String.valueOf(query.discreteInclusion()));
        queryElement.setAttribute("active", "" + query.isActive());
        queryElement.setAttribute("inclusionPlaces", this.getInclusionPlacesString(query));
        queryElement.setAttribute("overApproximation", "" + query.useOverApproximation());
        queryElement.setAttribute("reduction", "" + query.useReduction());
        queryElement.setAttribute("enableOverApproximation", "" + query.isOverApproximationEnabled());
        queryElement.setAttribute("enableUnderApproximation", "" + query.isUnderApproximationEnabled());
        queryElement.setAttribute("approximationDenominator", "" + query.approximationDenominator());
        queryElement.setAttribute("algorithmOption", String.valueOf((Object)query.getAlgorithmOption()));
        queryElement.setAttribute("useSiphonTrapAnalysis", "" + query.isSiphontrapEnabled());
        queryElement.setAttribute("useQueryReduction", "" + query.isQueryReductionEnabled());
        queryElement.setAttribute("useStubbornReduction", "" + query.isStubbornReductionEnabled());
        queryElement.setAttribute("useTarOption", "" + query.isTarOptionEnabled());
        queryElement.setAttribute("useTarjan", "" + query.isTarjan());
        return queryElement;
    }

    private Element createSMCQueryElement(TAPNQuery query, Document document) {
        Require.that(query != null, "Error: query was null");
        Require.that(document != null, "Error: document was null");
        Element queryElement = document.createElement("query");
        SMCQueryVisitor smcQueryVisitor = new SMCQueryVisitor();
        smcQueryVisitor.buildXMLQuery(query.getProperty(), query.getName(), query.getSmcSettings());
        try {
            Element doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(smcQueryVisitor.getXMLQuery().toString().getBytes())).getDocumentElement();
            Node smcTag = doc.getElementsByTagName("smc").item(0);
            Node formula = doc.getElementsByTagName("formula").item(0);
            Node observations = doc.getElementsByTagName("observations").item(0);
            queryElement.appendChild(document.importNode(smcTag, true));
            if (observations != null) {
                queryElement.appendChild(document.importNode(observations, true));
            }
            queryElement.appendChild(document.importNode(formula, true));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            System.out.println(String.valueOf(e) + " thrown in savePNML() : dataLayerWriter Class : dataLayer Package: filename=\"");
            return null;
        }
        queryElement.setAttribute("name", query.getName());
        queryElement.setAttribute("type", query.getCategory().toString());
        queryElement.setAttribute("capacity", "" + query.getCapacity());
        queryElement.setAttribute("traceOption", String.valueOf((Object)query.getTraceOption()));
        queryElement.setAttribute("reductionOption", String.valueOf((Object)query.getReductionOption()));
        queryElement.setAttribute("active", "" + query.isActive());
        queryElement.setAttribute("algorithmOption", String.valueOf((Object)query.getAlgorithmOption()));
        queryElement.setAttribute("timeDarts", "" + query.useTimeDarts());
        queryElement.setAttribute("gcd", "" + query.useGCD());
        queryElement.setAttribute("parallel", "" + query.isParallel());
        queryElement.setAttribute("overApproximation", "false");
        queryElement.setAttribute("verificationType", query.getVerificationType().toString());
        queryElement.setAttribute("numberOfTraces", "" + query.getNumberOfTraces());
        queryElement.setAttribute("smcTraceType", query.getSmcTraceType().toString());
        return queryElement;
    }

    private Node XMLQueryStringToElement(String formulaString) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(formulaString.getBytes())).getDocumentElement().getElementsByTagName("formula").item(0);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            System.out.println(String.valueOf(e) + " thrown in savePNML() : dataLayerWriter Class : dataLayer Package: filename=\"");
            return null;
        }
    }

    private String getInclusionPlacesString(TAPNQuery query) {
        if (!query.discreteInclusion() || query.inclusionPlaces().inclusionOption() == InclusionPlaces.InclusionPlacesOption.UserSpecified && query.inclusionPlaces().inclusionPlaces().isEmpty()) {
            return "*NONE*";
        }
        if (query.inclusionPlaces().inclusionOption() == InclusionPlaces.InclusionPlacesOption.AllPlaces) {
            return "*ALL*";
        }
        boolean first = true;
        StringBuilder s = new StringBuilder();
        for (TimedPlace p : query.inclusionPlaces().inclusionPlaces()) {
            if (!first) {
                s.append(',');
            }
            s.append(p.toString());
            if (!first) continue;
            first = false;
        }
        return s.toString();
    }

    private Element createPlaceElement(TimedPlaceComponent inputPlace, DataLayer guiModel, Document document) {
        Require.that(inputPlace != null, "Error: inputPlace was null");
        Require.that(guiModel != null, "Error: guiModel was null");
        Require.that(document != null, "Error: document was null");
        Element placeElement = document.createElement("place");
        placeElement.setAttribute("positionX", String.valueOf(inputPlace.getOriginalX()));
        placeElement.setAttribute("positionY", String.valueOf(inputPlace.getOriginalY()));
        placeElement.setAttribute("name", inputPlace.underlyingPlace().name());
        placeElement.setAttribute("displayName", inputPlace.getAttributesVisible() ? "true" : "false");
        placeElement.setAttribute("id", inputPlace.getId() != null ? inputPlace.getId() : "error");
        placeElement.setAttribute("nameOffsetX", String.valueOf(inputPlace.getNameOffsetX()));
        placeElement.setAttribute("nameOffsetY", String.valueOf(inputPlace.getNameOffsetY()));
        placeElement.setAttribute("initialMarking", Integer.valueOf(inputPlace.getNumberOfTokens()) != null ? String.valueOf((Object)inputPlace.getNumberOfTokens()) : "0");
        placeElement.setAttribute("invariant", inputPlace.underlyingPlace().invariant().toString());
        this.writeTACPN.appendColoredPlaceDependencies(inputPlace.underlyingPlace(), document, placeElement);
        this.createColoredInvariants(inputPlace.underlyingPlace(), document, placeElement);
        return placeElement;
    }

    private void createColoredInvariants(TimedPlace inputPlace, Document document, Element placeElement) {
        List<ColoredTimeInvariant> ctiList = inputPlace.getCtiList();
        for (ColoredTimeInvariant coloredTimeInvariant : ctiList) {
            Element invariant = document.createElement("colorinvariant");
            Element inscription = document.createElement("inscription");
            Element colortype = document.createElement("colortype");
            colortype.setAttribute("name", coloredTimeInvariant.getColor().getColorType().getName());
            if (coloredTimeInvariant.equalsOnlyColor(ColoredTimeInvariant.LESS_THAN_INFINITY_AND_STAR)) {
                placeElement.setAttribute("inscription", coloredTimeInvariant.getInvariantString(this.saveConstantNames));
                continue;
            }
            if (coloredTimeInvariant.getColor().getTuple() != null) {
                for (Color color : coloredTimeInvariant.getColor().getTuple()) {
                    Element colorEle = document.createElement("color");
                    colorEle.setAttribute("value", color.getColorName());
                    colortype.appendChild(colorEle);
                }
            } else {
                Element colorEle = document.createElement("color");
                colorEle.setAttribute("value", coloredTimeInvariant.getColor().getColorName());
                colortype.appendChild(colorEle);
            }
            inscription.setAttribute("inscription", coloredTimeInvariant.getInvariantString(this.saveConstantNames));
            invariant.appendChild(inscription);
            invariant.appendChild(colortype);
            placeElement.appendChild(invariant);
        }
    }

    private Element createAnnotationNoteElement(AnnotationNote inputLabel, Document document) {
        Require.that(inputLabel != null, "Error: inputLabel was null");
        Require.that(document != null, "Error: document was null");
        Element labelElement = document.createElement("labels");
        labelElement.setAttribute("positionX", (double)inputLabel.getOriginalX() >= 0.0 ? String.valueOf(inputLabel.getOriginalX()) : "");
        labelElement.setAttribute("positionY", (double)inputLabel.getOriginalY() >= 0.0 ? String.valueOf(inputLabel.getOriginalY()) : "");
        labelElement.setAttribute("width", (double)inputLabel.getNoteWidth() >= 0.0 ? String.valueOf(inputLabel.getNoteWidth()) : "");
        labelElement.setAttribute("height", (double)inputLabel.getNoteHeight() >= 0.0 ? String.valueOf(inputLabel.getNoteHeight()) : "");
        labelElement.setAttribute("border", String.valueOf(inputLabel.isShowingBorder()));
        Text text = document.createTextNode(inputLabel.getNoteText() != null ? inputLabel.getNoteText() : "");
        labelElement.appendChild(text);
        return labelElement;
    }

    private Element createTransitionElement(TimedTransitionComponent inputTransition, Document document) {
        Require.that(inputTransition != null, "Error: inputTransition was null");
        Require.that(document != null, "Error: document was null");
        Element transitionElement = document.createElement("transition");
        transitionElement.setAttribute("positionX", String.valueOf(inputTransition.getOriginalX()));
        transitionElement.setAttribute("positionY", String.valueOf(inputTransition.getOriginalY()));
        transitionElement.setAttribute("nameOffsetX", String.valueOf(inputTransition.getNameOffsetX()));
        transitionElement.setAttribute("nameOffsetY", String.valueOf(inputTransition.getNameOffsetY()));
        transitionElement.setAttribute("name", inputTransition.underlyingTransition().name());
        transitionElement.setAttribute("displayName", inputTransition.getAttributesVisible() ? "true" : "false");
        transitionElement.setAttribute("id", inputTransition.getId() != null ? inputTransition.getId() : "error");
        transitionElement.setAttribute("infiniteServer", "false");
        transitionElement.setAttribute("angle", String.valueOf(inputTransition.getAngle()));
        transitionElement.setAttribute("priority", "0");
        transitionElement.setAttribute("urgent", inputTransition.underlyingTransition().isUrgent() ? "true" : "false");
        transitionElement.setAttribute("player", inputTransition.underlyingTransition().isUncontrollable() ? "1" : "0");
        transitionElement.setAttribute("weight", inputTransition.underlyingTransition().getWeight().nameForSaving(this.saveConstantNames));
        transitionElement.setAttribute("firingMode", inputTransition.underlyingTransition().getFiringMode().toString());
        inputTransition.underlyingTransition().getDistribution().writeToXml(transitionElement);
        this.writeTACPN.appendColoredTransitionDependencies(inputTransition.underlyingTransition(), document, transitionElement);
        return transitionElement;
    }

    private Element createArcElement(Arc inputArc, DataLayer guiModel, Document document) {
        Require.that(inputArc != null, "Error: inputArc was null");
        Require.that(guiModel != null, "Error: guiModel was null");
        Require.that(document != null, "Error: document was null");
        Element arcElement = document.createElement("arc");
        arcElement.setAttribute("id", inputArc.getId() != null ? inputArc.getId() : "error");
        arcElement.setAttribute("source", inputArc.getSource().getId() != null ? inputArc.getSource().getId() : "");
        arcElement.setAttribute("target", inputArc.getTarget().getId() != null ? inputArc.getTarget().getId() : "");
        arcElement.setAttribute("nameOffsetX", String.valueOf(inputArc.getNameOffsetX()));
        arcElement.setAttribute("nameOffsetY", String.valueOf(inputArc.getNameOffsetY()));
        if (inputArc instanceof TimedOutputArcComponent) {
            if (inputArc instanceof TimedInputArcComponent) {
                if (this.getInputArcTypeAsString((TimedInputArcComponent)inputArc).equals("transport")) {
                    if (this.secondTransport) {
                        arcElement.setAttribute("transportID", String.valueOf(this.transporCountID));
                        this.secondTransport = false;
                    } else {
                        ++this.transporCountID;
                        arcElement.setAttribute("transportID", String.valueOf(this.transporCountID));
                        this.secondTransport = true;
                    }
                }
                arcElement.setAttribute("type", this.getInputArcTypeAsString((TimedInputArcComponent)inputArc));
                arcElement.setAttribute("inscription", this.getGuardAsString((TimedInputArcComponent)inputArc));
                arcElement.setAttribute("weight", inputArc.getWeight().nameForSaving(true));
                if (!(inputArc instanceof TimedInhibitorArcComponent)) {
                    this.appendArcIntervals((TimedInputArcComponent)inputArc, document, arcElement);
                }
            } else {
                arcElement.setAttribute("type", "normal");
                arcElement.setAttribute("inscription", "1");
                arcElement.setAttribute("weight", inputArc.getWeight().nameForSaving(true));
            }
        }
        if (!(inputArc instanceof TimedInhibitorArcComponent)) {
            this.writeTACPN.appendColoredArcsDependencies(inputArc, guiModel, document, arcElement);
        }
        return arcElement;
    }

    private void appendArcIntervals(TimedInputArcComponent inputArc, Document document, Element arcElement) {
        List<ColoredTimeInterval> ctiList;
        if (inputArc instanceof TimedTransportArcComponent) {
            TransportArc arc = ((TimedTransportArcComponent)inputArc).underlyingTransportArc();
            ctiList = arc.getColorTimeIntervals();
        } else {
            ctiList = inputArc.underlyingTimedInputArc().getColorTimeIntervals();
        }
        for (ColoredTimeInterval cti : ctiList) {
            if (cti.equalsOnlyColor(ColoredTimeInterval.ZERO_INF_DYN_COLOR(Color.STAR_COLOR))) {
                arcElement.setAttribute("inscription", cti.getInterval(this.saveConstantNames));
                continue;
            }
            Element interval = document.createElement("colorinterval");
            Element inscription = document.createElement("inscription");
            Element colortype = document.createElement("colortype");
            inscription.setAttribute("inscription", cti.getInterval(this.saveConstantNames));
            colortype.setAttribute("name", cti.getColor().getColorType().getName());
            if (cti.getColor().getTuple() != null) {
                for (Color color : cti.getColor().getTuple()) {
                    Element colorEle = document.createElement("color");
                    colorEle.setAttribute("value", color.getColorName());
                    colortype.appendChild(colorEle);
                }
            } else {
                Element colorEle = document.createElement("color");
                colorEle.setAttribute("value", cti.getColor().getColorName());
                colortype.appendChild(colorEle);
            }
            interval.appendChild(inscription);
            interval.appendChild(colortype);
            arcElement.appendChild(interval);
        }
    }

    private String getInputArcTypeAsString(TimedInputArcComponent inputArc) {
        if (inputArc instanceof TimedTransportArcComponent) {
            return "transport";
        }
        if (inputArc instanceof TimedInhibitorArcComponent) {
            return "tapnInhibitor";
        }
        return "timed";
    }

    private String getGuardAsString(TimedInputArcComponent inputArc) {
        if (inputArc instanceof TimedTransportArcComponent) {
            return inputArc.getGuardAsString() + ":" + ((TimedTransportArcComponent)inputArc).getGroupNr();
        }
        return inputArc.getGuardAsString();
    }

    private Element createArcPoint(String x, String y, String type, Document document, int id) {
        Require.that(document != null, "Error: document was null");
        Element arcPoint = document.createElement("arcpath");
        arcPoint.setAttribute("id", String.valueOf(id));
        arcPoint.setAttribute("xCoord", x);
        arcPoint.setAttribute("yCoord", y);
        arcPoint.setAttribute("arcPointType", type);
        return arcPoint;
    }
}

