/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io;

import dk.aau.cs.io.IdResolver;
import dk.aau.cs.io.LoadTACPN;
import dk.aau.cs.io.LoadedModel;
import dk.aau.cs.io.NamePurifier;
import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorMultiset;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Expressions.AddExpression;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.DotConstantExpression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.IntWeight;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.util.FormatException;
import dk.aau.cs.util.Require;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.tapaal.gui.petrinet.NameGenerator;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;

public class PNMLoader {
    private TAPNLens lens;
    private final NameGenerator nameGenerator = new NameGenerator();
    private final IdResolver idResolver = new IdResolver();
    private final HashSet<String> arcs = new HashSet();
    private final HashMap<String, TimedPlace> places = new HashMap();
    private final HashMap<String, TimedTransition> transitions = new HashMap();
    private final HashMap<String, ColorType> colortypes = new HashMap();
    private final HashMap<String, Variable> variables = new HashMap();
    private int netSize = 0;
    private final int maxNetSize = 4000;
    private boolean hasPositionalInfo = false;
    private final LoadTACPN loadTACPN;

    public PNMLoader() {
        this.lens = TAPNLens.Default;
        this.loadTACPN = new LoadTACPN();
    }

    public LoadedModel load(File file) throws FormatException {
        try {
            return this.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (NullPointerException e) {
            throw new FormatException("the PNML file cannot be parsed due to syntax errors", e);
        }
    }

    public LoadedModel load(InputStream file) throws FormatException {
        Document doc = this.loadDocument(file);
        return this.parse(doc);
    }

    private Document loadDocument(InputStream file) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(file);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }

    private LoadedModel parse(Document doc) throws FormatException {
        this.idResolver.clear();
        TimedArcPetriNetNetwork network = new TimedArcPetriNetNetwork();
        Node pnmlElement = doc.getElementsByTagName("pnml").item(0);
        Node netNode = this.getFirstDirectChild(pnmlElement, "net");
        this.lens = new TAPNLens(false, false, this.getFirstDirectChild(netNode, "declaration") != null, false);
        String name = this.getTAPNName(netNode);
        TimedArcPetriNet tapn = new TimedArcPetriNet(name);
        tapn.setCheckNames(false);
        network.add(tapn);
        this.nameGenerator.add(tapn);
        Template template = new Template(tapn, new DataLayer(), new Zoomer());
        this.parseTimedArcPetriNet(netNode, tapn, template, network);
        template.setHasPositionalInfo(this.hasPositionalInfo);
        network.setPaintNet(this.isNetDrawable());
        tapn.setCheckNames(true);
        return new LoadedModel(network, List.of(template), new ArrayList<TAPNQuery>(), new ArrayList<String>(), this.lens);
    }

    private String getTAPNName(Node netNode) {
        if (!(netNode instanceof Element)) {
            return this.nameGenerator.getNewTemplateName();
        }
        String result = null;
        Node name = this.getFirstDirectChild(netNode, "name");
        if (name != null) {
            result = this.getFirstDirectChild(name, "text").getTextContent();
        }
        if (name == null || name.equals("")) {
            return this.nameGenerator.getNewTemplateName();
        }
        return NamePurifier.purify(result);
    }

    private void parseTimedArcPetriNet(Node netNode, TimedArcPetriNet tapn, Template template, TimedArcPetriNetNetwork network) throws FormatException {
        String tag;
        Node node;
        if (this.lens.isColored()) {
            Node declarations = this.getFirstDirectChild(netNode, "declaration");
            this.loadTACPN.parseDeclarations(declarations, network);
        }
        Node first = node = this.getFirstDirectChild(netNode, "page").getFirstChild();
        while (node != null) {
            ++this.netSize;
            node = node.getNextSibling();
        }
        for (node = first; node != null; node = node.getNextSibling()) {
            tag = node.getNodeName();
            if (tag.equals("place")) {
                this.parsePlace(node, tapn, template);
                continue;
            }
            if (!tag.equals("transition")) continue;
            this.parseTransition(node, tapn, template);
        }
        for (node = first; node != null; node = node.getNextSibling()) {
            tag = node.getNodeName();
            if (!tag.equals("arc")) continue;
            this.parseArc(node, template);
        }
    }

    private void parsePlace(Node node, TimedArcPetriNet tapn, Template template) throws FormatException {
        LocalTimedPlace place;
        Node markingNode;
        if (!(node instanceof Element)) {
            return;
        }
        Name name = this.parseName(this.getFirstDirectChild(node, "name"));
        if (name == null) {
            name = new Name(this.nameGenerator.getNewPlaceName(template.model()));
        }
        Point position = this.parseGraphics(this.getFirstDirectChild(node, "graphics"), GraphicsType.Position);
        String id = NamePurifier.purify(((Element)node).getAttribute("id"));
        ArcExpression colorMarking = null;
        InitialMarking marking = this.parseMarking(this.getFirstDirectChild(node, "initialMarking"));
        ColorType colorType = ColorType.COLORTYPE_DOT;
        Node typeNode = this.getFirstDirectChild(node, "type");
        if (typeNode != null) {
            try {
                colorType = this.loadTACPN.parseUserSort(typeNode);
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
        }
        if ((markingNode = this.getFirstDirectChild(node, "hlinitialMarking")) instanceof Element) {
            try {
                colorMarking = this.loadTACPN.parseArcExpression(((Element)markingNode).getElementsByTagName("structure").item(0));
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
        }
        Require.that(this.places.put(id, place = new LocalTimedPlace(id, colorType)) == null && !this.transitions.containsKey(id), "The name: " + id + ", was already used");
        tapn.add(place);
        TimedPlaceComponent placeComponent = new TimedPlaceComponent(position.x, position.y, id, name.point.x, name.point.y, this.lens);
        placeComponent.setUnderlyingPlace(place);
        template.guiModel().addPetriNetObject(placeComponent);
        this.idResolver.add(tapn.name(), id, id);
        if (colorMarking != null) {
            ExpressionContext context = new ExpressionContext(new HashMap<String, Color>(), this.loadTACPN.getColortypes());
            ColorMultiset cm = colorMarking.eval(context);
            place.setTokenExpression(this.loadTACPN.constructCleanAddExpression(colorMarking));
            for (TimedToken ct : cm.getTokens(place)) {
                tapn.parentNetwork().marking().add(ct);
            }
        } else {
            for (int i = 0; i < marking.marking; ++i) {
                tapn.parentNetwork().marking().add(new TimedToken(place, ColorType.COLORTYPE_DOT.getFirstColor()));
            }
            if (marking.marking > 1) {
                Vector<ColorExpression> v = new Vector<ColorExpression>();
                v.add(new DotConstantExpression());
                Vector<ArcExpression> numbOfExpression = new Vector<ArcExpression>();
                numbOfExpression.add(new NumberOfExpression(marking.marking, v));
                place.setTokenExpression(new AddExpression(numbOfExpression));
            }
        }
    }

    private static Node skipWS(Node node) {
        if (node != null && !(node instanceof Element)) {
            return PNMLoader.skipWS(node.getNextSibling());
        }
        return node;
    }

    private static Node getAttribute(Node node, String attribute) {
        return node.getAttributes().getNamedItem(attribute);
    }

    private InitialMarking parseMarking(Node node) {
        if (!(node instanceof Element)) {
            return new InitialMarking();
        }
        Point offset = this.parseGraphics(this.getFirstDirectChild(node, "graphics"), GraphicsType.Offset);
        int marking = Integer.parseInt(this.getFirstDirectChild(node, "text").getTextContent());
        return new InitialMarking(marking, offset);
    }

    private void parseTransition(Node node, TimedArcPetriNet tapn, Template template) throws FormatException {
        TimedTransition transition;
        if (!(node instanceof Element)) {
            return;
        }
        Point position = this.parseGraphics(this.getFirstDirectChild(node, "graphics"), GraphicsType.Position);
        Name name = this.parseName(this.getFirstDirectChild(node, "name"));
        if (name == null) {
            name = new Name(this.nameGenerator.getNewTransitionName(template.model()));
        }
        String id = NamePurifier.purify(((Element)node).getAttribute("id"));
        GuardExpression guardExpression = null;
        Node conditionNode = this.getFirstDirectChild(node, "condition");
        if (conditionNode != null) {
            guardExpression = this.loadTACPN.parseGuardExpression(this.getFirstDirectChild(conditionNode, "structure"));
        }
        Require.that(this.transitions.put(id, transition = new TimedTransition(id, guardExpression)) == null && !this.places.containsKey(id), "The id: " + id + ", was already used");
        tapn.add(transition);
        TimedTransitionComponent transitionComponent = new TimedTransitionComponent(position.x, position.y, id, name.point.x, name.point.y, 0, this.lens);
        transitionComponent.setUnderlyingTransition(transition);
        template.guiModel().addPetriNetObject(transitionComponent);
        this.idResolver.add(tapn.name(), id, id);
    }

    private void parseArc(Node node, Template template) throws FormatException {
        Arc tempArc;
        Node text;
        if (!(node instanceof Element)) {
            return;
        }
        Element element = (Element)node;
        String id = element.getAttribute("id");
        String sourceId = NamePurifier.purify(element.getAttribute("source"));
        String targetId = NamePurifier.purify(element.getAttribute("target"));
        String type = element.getAttribute("type");
        String sourceName = this.idResolver.get(template.model().name(), sourceId);
        String targetName = this.idResolver.get(template.model().name(), targetId);
        TimedPlace sourcePlace = this.places.get(sourceName);
        TimedPlace targetPlace = this.places.get(targetName);
        TimedTransition sourceTransition = this.transitions.get(sourceName);
        TimedTransition targetTransition = this.transitions.get(targetName);
        PlaceTransitionObject source = template.guiModel().getPlaceTransitionObject(sourceName);
        PlaceTransitionObject target = template.guiModel().getPlaceTransitionObject(targetName);
        int weight = 1;
        Node inscription = this.getFirstDirectChild(node, "inscription");
        if (inscription != null && (text = this.getFirstDirectChild(inscription, "text")) != null) {
            String weightString = text.getTextContent().trim();
            try {
                weight = Integer.parseInt(weightString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int _startx = 0;
        int _starty = 0;
        int _endx = 0;
        int _endy = 0;
        if (this.isNetDrawable()) {
            _startx = source.getX() + source.centreOffsetLeft();
            _starty = source.getY() + source.centreOffsetTop();
            _endx = target.getX() + target.centreOffsetLeft();
            _endy = target.getY() + target.centreOffsetTop();
        }
        ArcExpression arcExpression = null;
        Node hlInscriptionNode = this.getFirstDirectChild(node, "hlinscription");
        if (hlInscriptionNode != null) {
            arcExpression = this.loadTACPN.parseArcExpression(this.getFirstDirectChild(hlInscriptionNode, "structure"));
        }
        if (type != null && type.equals("inhibitor")) {
            tempArc = this.parseAndAddTimedInhibitorArc(id, sourcePlace, targetTransition, source, target, weight, arcExpression, _endx, _endy, template);
        } else if (sourcePlace != null && targetTransition != null) {
            tempArc = this.parseInputArc(id, sourcePlace, targetTransition, source, target, weight, arcExpression, _endx, _endy, template);
        } else if (sourceTransition != null && targetPlace != null) {
            tempArc = this.parseOutputArc(id, sourceTransition, targetPlace, source, target, weight, arcExpression, _endx, _endy, template);
        } else {
            throw new FormatException("Arcs must be only between places and transitions");
        }
        if (this.isNetDrawable()) {
            this.parseArcPath(element, tempArc);
        }
    }

    private void parseArcPath(Element arc, Arc tempArc) {
        Element element = (Element)this.getFirstDirectChild(arc, "graphics");
        if (element == null) {
            return;
        }
        NodeList nodelist = element.getElementsByTagName("position");
        if (nodelist.getLength() > 0) {
            for (int i = 0; i < nodelist.getLength(); ++i) {
                Element position;
                Node node = nodelist.item(i);
                if (!(node instanceof Element) || !"position".equals((position = (Element)node).getNodeName())) continue;
                String arcTempX = position.getAttribute("x");
                String arcTempY = position.getAttribute("y");
                double arcPointX = Double.parseDouble(arcTempX);
                double arcPointY = Double.parseDouble(arcTempY);
                tempArc.getArcPath().addPoint(i + 1, arcPointX += 4.0, arcPointY += 4.0, false);
            }
        }
    }

    private Name parseName(Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        Point offset = this.parseGraphics(this.getFirstDirectChild(node, "graphics"), GraphicsType.Offset);
        String name = this.getFirstDirectChild(node, "text").getTextContent();
        if (name == null || name.equals("")) {
            return null;
        }
        name = NamePurifier.purify(name);
        return new Name(name, offset);
    }

    private Point parseGraphics(Node node, GraphicsType type) {
        if (!(node instanceof Element)) {
            if (type == GraphicsType.Offset) {
                return new Point(0, -10);
            }
            return new Point(100, 100);
        }
        this.hasPositionalInfo = true;
        Element offset = (Element)this.getFirstDirectChild(node, type == GraphicsType.Offset ? "offset" : "position");
        String x = offset.getAttribute("x");
        String y = offset.getAttribute("y");
        int xd = Math.round(Float.parseFloat(x));
        int yd = Math.round(Float.parseFloat(y));
        return new Point(xd, yd);
    }

    private TimedInputArcComponent parseInputArc(String arcId, TimedPlace place, TimedTransition transition, PlaceTransitionObject source, PlaceTransitionObject target, int weight, ArcExpression arcExpression, int _endx, int _endy, Template template) throws FormatException {
        TimedInputArc inputArc = new TimedInputArc(place, transition, TimeInterval.ZERO_INF, new IntWeight(weight), arcExpression);
        Require.that(this.places.containsKey(inputArc.source().name()), "The source place must be part of the petri net.");
        Require.that(this.transitions.containsKey(inputArc.destination().name()), "The destination transition must be part of the petri net");
        if (!this.arcs.add(inputArc.source().name() + "-in-" + inputArc.destination().name())) {
            throw new FormatException("Multiple arcs between a place and a transition is not allowed");
        }
        TimedInputArcComponent arc = null;
        if (this.isNetDrawable()) {
            arc = new TimedInputArcComponent(new TimedOutputArcComponent(source, target, weight, arcId), this.lens);
            arc.setUnderlyingArc(inputArc);
            template.guiModel().addPetriNetObject(arc);
        }
        template.model().add(inputArc);
        return arc;
    }

    private Arc parseOutputArc(String arcId, TimedTransition transition, TimedPlace place, PlaceTransitionObject source, PlaceTransitionObject target, int weight, ArcExpression arcExpression, int _endx, int _endy, Template template) throws FormatException {
        TimedOutputArc outputArc = new TimedOutputArc(transition, place, new IntWeight(weight), arcExpression);
        Require.that(this.places.containsKey(outputArc.destination().name()), "The destination place must be part of the petri net.");
        Require.that(this.transitions.containsKey(outputArc.source().name()), "The source transition must be part of the petri net");
        if (!this.arcs.add(outputArc.source().name() + "-out-" + outputArc.destination().name())) {
            throw new FormatException("Multiple arcs between a place and a transition is not allowed");
        }
        TimedOutputArcComponent arc = null;
        if (this.isNetDrawable()) {
            arc = new TimedOutputArcComponent(source, target, weight, arcId);
            arc.setUnderlyingArc(outputArc);
            template.guiModel().addPetriNetObject(arc);
        }
        template.model().add(outputArc);
        return arc;
    }

    private Arc parseAndAddTimedInhibitorArc(String arcId, TimedPlace place, TimedTransition transition, PlaceTransitionObject source, PlaceTransitionObject target, int weight, ArcExpression arcExpression, int _endx, int _endy, Template template) {
        TimedInhibitorArcComponent tempArc = new TimedInhibitorArcComponent(new TimedInputArcComponent(new TimedOutputArcComponent(source, target, weight, arcId)));
        TimedInhibitorArc inhibArc = new TimedInhibitorArc(place, transition, TimeInterval.ZERO_INF, new IntWeight(weight), arcExpression);
        tempArc.setUnderlyingArc(inhibArc);
        template.guiModel().addPetriNetObject(tempArc);
        template.model().add(inhibArc);
        return tempArc;
    }

    private boolean isNetDrawable() {
        return this.netSize <= 4000;
    }

    Node getFirstDirectChild(Node parent, String tagName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equals(tagName)) continue;
            return children.item(i);
        }
        return null;
    }

    private static class Name {
        final String name;
        final Point point;

        public Name(String newPlaceName) {
            this(newPlaceName, new Point());
        }

        public Name(String name, Point p) {
            this.name = name;
            this.point = p;
        }

        public String toString() {
            return this.name + ";" + String.valueOf(this.point);
        }
    }

    static enum GraphicsType {
        Position,
        Offset;

    }

    private static class InitialMarking {
        final int marking;
        final Point point;

        public InitialMarking() {
            this(0, new Point());
        }

        public InitialMarking(int marking, Point p) {
            this.marking = marking;
            this.point = p;
        }

        public String toString() {
            return this.marking + ";" + String.valueOf(this.point);
        }
    }
}

