/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Expressions.AddExpression;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.AndExpression;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.DotConstantExpression;
import dk.aau.cs.model.CPN.Expressions.EqualityExpression;
import dk.aau.cs.model.CPN.Expressions.GreaterThanEqExpression;
import dk.aau.cs.model.CPN.Expressions.GreaterThanExpression;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Expressions.InequalityExpression;
import dk.aau.cs.model.CPN.Expressions.LessThanEqExpression;
import dk.aau.cs.model.CPN.Expressions.LessThanExpression;
import dk.aau.cs.model.CPN.Expressions.NotExpression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Expressions.OrExpression;
import dk.aau.cs.model.CPN.Expressions.PredecessorExpression;
import dk.aau.cs.model.CPN.Expressions.ScalarProductExpression;
import dk.aau.cs.model.CPN.Expressions.SubtractExpression;
import dk.aau.cs.model.CPN.Expressions.SuccessorExpression;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.Expressions.VariableExpression;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.util.FormatException;
import dk.aau.cs.util.NameTransformer;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.Tuple;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.function.Consumer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoadTACPN {
    private final HashMap<String, ColorType> colortypes = new HashMap();
    private final HashMap<String, Variable> variables = new HashMap();
    private final HashMap<String, ColorExpression> tupleVarExpressions = new HashMap();
    private final Collection<String> messages = new ArrayList<String>(10);
    private final Collection<Node> productTypes = new ArrayList<Node>();
    private final NameTransformer nc = new NameTransformer();

    public HashMap<String, ColorType> getColortypes() {
        return this.colortypes;
    }

    public HashMap<String, Variable> getVariables() {
        return this.variables;
    }

    public Collection<String> getMessages() {
        return this.messages;
    }

    private static Node skipWS(Node node) {
        if (node != null && !(node instanceof Element)) {
            return LoadTACPN.skipWS(node.getNextSibling());
        }
        return node;
    }

    private static Node getAttribute(Node node, String attribute) {
        return node.getAttributes().getNamedItem(attribute);
    }

    private Element expectElementTagOrEmpty(String tag, Node node) throws FormatException {
        if (node == null) {
            return null;
        }
        if (!(node instanceof Element) || !node.getNodeName().equals(tag)) {
            throw new FormatException("Unexpected node, expected " + tag + " got " + node.getNodeName());
        }
        return (Element)node;
    }

    private void forEachElementInNodeList(NodeList list, Consumer<Element> function) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            function.accept(el);
        }
    }

    public void parseDeclarations(Node node, TimedArcPetriNetNetwork network) throws FormatException {
        Element declaration = this.expectElementTagOrEmpty("declaration", node);
        Element structure = this.expectElementTagOrEmpty("structure", LoadTACPN.skipWS(declaration.getFirstChild()));
        Element declarations = this.expectElementTagOrEmpty("declarations", LoadTACPN.skipWS(structure.getFirstChild()));
        NodeList namedSorts = declarations.getElementsByTagName("namedsort");
        this.forEachElementInNodeList(namedSorts, element -> this.parseNamedSort((Node)element, network));
        for (Node n : this.productTypes) {
            Node type = LoadTACPN.skipWS(n.getFirstChild());
            String typeTag = type.getNodeName();
            if (!typeTag.equals("productsort")) {
                throw new FormatException("Expected productsort type got: " + typeTag);
            }
            String name = this.nc.transform(LoadTACPN.getAttribute(n, "name").getNodeValue());
            String id = LoadTACPN.getAttribute(n, "id").getNodeValue();
            ProductType pt = new ProductType(name);
            Node typechild = LoadTACPN.skipWS(type.getFirstChild());
            while (typechild != null) {
                if (typechild.getNodeName().equals("usersort")) {
                    String constituent = LoadTACPN.getAttribute(typechild, "declaration").getNodeValue();
                    pt.addType(this.colortypes.get(constituent));
                }
                typechild = LoadTACPN.skipWS(typechild.getNextSibling());
            }
            Require.that(this.colortypes.put(id, pt) == null, "the name " + id + ", was already used");
            network.add(pt);
        }
        this.productTypes.clear();
        NodeList variabledecl = declarations.getElementsByTagName("variabledecl");
        this.forEachElementInNodeList(variabledecl, element -> {
            ColorType ct;
            String name;
            Variable var;
            String id = LoadTACPN.getAttribute(element, "id").getNodeValue();
            Require.that(this.variables.put(id, var = new Variable(name = this.nc.transform(LoadTACPN.getAttribute(element, "name").getNodeValue()), id, ct = this.parseUserSort((Node)element))) == null, "the id " + id + ", was already used");
            network.add(var);
        });
        Vector<String> variablesForRemoval = new Vector<String>();
        HashMap<CallSite, Variable> newVars = new HashMap<CallSite, Variable>();
        StringBuilder renameWarnings = new StringBuilder();
        for (String varName : this.variables.keySet()) {
            Variable var = this.variables.get(varName);
            if (!var.getColorType().isProductColorType()) continue;
            int constituentCounter = 1;
            Vector<ColorExpression> constituentVarExpressions = new Vector<ColorExpression>();
            renameWarnings.append("The product variable ").append(var.getName()).append(", was unfolded to (");
            for (ColorType colorType : var.getColorType().getProductColorTypes()) {
                StringBuilder elementSubstring = new StringBuilder("_" + constituentCounter);
                while (this.variables.containsKey(varName + String.valueOf(elementSubstring)) || newVars.containsKey(varName + String.valueOf(elementSubstring))) {
                    elementSubstring.append("_1");
                }
                renameWarnings.append(varName).append((CharSequence)elementSubstring).append(",");
                String name = this.nc.transform(var.getName() + String.valueOf(elementSubstring));
                Variable newVar = new Variable(name, varName + String.valueOf(elementSubstring), colorType);
                Require.that(newVars.put((CallSite)((Object)(varName + String.valueOf(elementSubstring))), newVar) == null, "the id " + varName + String.valueOf(elementSubstring) + ", was already used");
                network.add(newVar);
                constituentVarExpressions.addElement(new VariableExpression(newVar));
                ++constituentCounter;
            }
            renameWarnings.deleteCharAt(renameWarnings.length() - 1);
            renameWarnings.append(")\n");
            this.tupleVarExpressions.put(varName, new TupleExpression(constituentVarExpressions));
            network.remove(var);
            variablesForRemoval.addElement(varName);
        }
        for (String varName : variablesForRemoval) {
            this.variables.remove(varName);
        }
        for (String varName : newVars.keySet()) {
            this.variables.put(varName, (Variable)newVars.get(varName));
        }
        if (renameWarnings.length() > 0) {
            this.messages.add(renameWarnings.toString());
        }
    }

    private void parseNamedSort(Node node, TimedArcPetriNetNetwork network) throws FormatException {
        this.colortypes.put("dot", ColorType.COLORTYPE_DOT);
        network.add(ColorType.COLORTYPE_DOT);
        Node type = LoadTACPN.skipWS(node.getFirstChild());
        String typetag = type.getNodeName();
        String name = this.nc.transform(LoadTACPN.getAttribute(node, "name").getNodeValue());
        String id = LoadTACPN.getAttribute(node, "id").getNodeValue();
        if (typetag.equals("productsort")) {
            this.productTypes.add(node);
        } else {
            ColorType ct = new ColorType(name);
            if (typetag.equals("dot")) {
                return;
            }
            if (typetag.equals("finiteintrange")) {
                int start = Integer.parseInt(LoadTACPN.getAttribute(type, "start").getNodeValue());
                int end = Integer.parseInt(LoadTACPN.getAttribute(type, "end").getNodeValue());
                for (int i = start; i <= end; ++i) {
                    ct.addColor(String.valueOf(i));
                }
            } else {
                Node typechild = LoadTACPN.skipWS(type.getFirstChild());
                while (typechild != null) {
                    Node colorId = LoadTACPN.getAttribute(typechild, "id");
                    if (colorId != null) {
                        String colorName = this.nc.transform(colorId.getNodeValue());
                        ct.addColor(colorName);
                        typechild = LoadTACPN.skipWS(typechild.getNextSibling());
                        continue;
                    }
                    throw new FormatException(String.format("No id found on %s\n", typechild.getNodeName()));
                }
            }
            Require.that(this.colortypes.put(id, ct) == null, "the name " + id + ", was already used");
            network.add(ct);
        }
    }

    public ColorType parseUserSort(Node node) throws FormatException {
        if (node instanceof Element) {
            Node child = LoadTACPN.skipWS(node.getFirstChild());
            while (child != null) {
                String name = child.getNodeName();
                if (name.equals("usersort")) {
                    Node decl = LoadTACPN.getAttribute(child, "declaration");
                    return this.colortypes.get(decl.getNodeValue());
                }
                if (name.matches("structure|type|subterm")) {
                    return this.parseUserSort(child);
                }
                child = LoadTACPN.skipWS(child.getNextSibling());
            }
        }
        throw new FormatException(String.format("Could not parse %s as an usersort\n", node.getNodeName()));
    }

    public ArcExpression parseArcExpression(Node node) throws FormatException {
        String name = node.getNodeName();
        if (name.equals("numberof")) {
            return this.parseNumberOfExpression(node);
        }
        if (name.equals("add")) {
            Vector<ArcExpression> constituents = new Vector<ArcExpression>();
            Node child = LoadTACPN.skipWS(node.getFirstChild());
            while (child != null) {
                ArcExpression subterm = this.parseArcExpression(child);
                constituents.add(subterm);
                child = LoadTACPN.skipWS(child.getNextSibling());
            }
            AddExpression addExpr = new AddExpression(constituents);
            for (ArcExpression expr : constituents) {
                expr.setParent(addExpr);
            }
            return addExpr;
        }
        if (name.equals("subtract")) {
            Node headchild = LoadTACPN.skipWS(node.getFirstChild());
            ArcExpression headexp = this.parseArcExpression(headchild);
            Node nextchild = LoadTACPN.skipWS(headchild.getNextSibling());
            while (nextchild != null) {
                ArcExpression nextexp = this.parseArcExpression(nextchild);
                SubtractExpression subExpr = new SubtractExpression(headexp, nextexp);
                headexp.setParent(subExpr);
                nextexp.setParent(subExpr);
                headexp = subExpr;
                nextchild = LoadTACPN.skipWS(nextchild.getNextSibling());
            }
            return headexp;
        }
        if (name.equals("scalarproduct")) {
            Node scalar = LoadTACPN.skipWS(node.getFirstChild());
            Integer scalarval = this.parseNumberConstantExpression(scalar);
            Node child = LoadTACPN.skipWS(scalar.getNextSibling());
            ArcExpression childexp = this.parseArcExpression(child);
            ScalarProductExpression scalarExpr = new ScalarProductExpression(scalarval, childexp);
            childexp.setParent(scalarExpr);
            return scalarExpr;
        }
        if (name.equals("all")) {
            ColorType ct = this.parseUserSort(node);
            Vector<ColorExpression> ceVector = new Vector<ColorExpression>();
            ceVector.add(new AllExpression(ct));
            return new NumberOfExpression(1, ceVector);
        }
        if (name.matches("subterm|structure")) {
            Node child = LoadTACPN.skipWS(node.getFirstChild());
            return this.parseArcExpression(child);
        }
        if (name.matches("tuple")) {
            Vector<ColorExpression> ceVector = new Vector<ColorExpression>();
            ceVector.add(this.parseColorExpression(node));
            return new NumberOfExpression(1, ceVector);
        }
        throw new FormatException(String.format("Could not parse %s as an arc expression\n", name));
    }

    private NumberOfExpression parseNumberOfExpression(Node node) throws FormatException {
        Node subnode;
        Node number = LoadTACPN.skipWS(node.getFirstChild());
        Integer numberval = this.parseNumberConstantExpression(number);
        if (numberval != null) {
            subnode = LoadTACPN.skipWS(number.getNextSibling());
        } else {
            subnode = number;
            numberval = 1;
        }
        Vector<ColorExpression> colorexps = new Vector<ColorExpression>();
        while (subnode != null) {
            ColorExpression colorexp = this.parseColorExpression(subnode);
            colorexps.add(colorexp);
            subnode = LoadTACPN.skipWS(subnode.getNextSibling());
        }
        return new NumberOfExpression(numberval, colorexps);
    }

    private Integer parseNumberConstantExpression(Node node) {
        String name = node.getNodeName();
        if (name.equals("numberconstant")) {
            String value = LoadTACPN.getAttribute(node, "value").getNodeValue();
            return Integer.valueOf(value);
        }
        if (name.equals("subterm")) {
            Node child = LoadTACPN.skipWS(node.getFirstChild());
            return this.parseNumberConstantExpression(child);
        }
        return null;
    }

    private ColorExpression parseColorExpression(Node node) throws FormatException {
        String name = node.getNodeName();
        if (name.equals("dotconstant")) {
            return new DotConstantExpression();
        }
        if (name.equals("variable")) {
            String varname = LoadTACPN.getAttribute(node, "refvariable").getNodeValue();
            Variable var = this.variables.get(varname);
            if (var != null) {
                return new VariableExpression(var);
            }
            return this.tupleVarExpressions.get(varname);
        }
        if (name.equals("useroperator")) {
            String colorname = this.nc.transform(LoadTACPN.getAttribute(node, "declaration").getNodeValue());
            Color color = this.getColor(colorname);
            return new UserOperatorExpression(color);
        }
        if (name.equals("successor")) {
            Node child = LoadTACPN.skipWS(node.getFirstChild());
            ColorExpression childexp = this.parseColorExpression(child);
            return new SuccessorExpression(childexp);
        }
        if (name.equals("predecessor")) {
            Node child = LoadTACPN.skipWS(node.getFirstChild());
            ColorExpression childexp = this.parseColorExpression(child);
            return new PredecessorExpression(childexp);
        }
        if (name.equals("all")) {
            ColorType ct = this.parseUserSort(node);
            return new AllExpression(ct);
        }
        if (name.equals("tuple")) {
            Vector<ColorExpression> colorexps = new Vector<ColorExpression>();
            Node child = LoadTACPN.skipWS(node.getFirstChild());
            while (child != null) {
                ColorExpression colorexp = this.parseColorExpression(child);
                colorexps.add(colorexp);
                child = LoadTACPN.skipWS(child.getNextSibling());
            }
            if (colorexps.size() < 2) {
                return (ColorExpression)colorexps.get(0);
            }
            return new TupleExpression(colorexps);
        }
        if (name.matches("subterm|structure")) {
            Node child = LoadTACPN.skipWS(node.getFirstChild());
            return this.parseColorExpression(child);
        }
        if (name.equals("finiteintrangeconstant")) {
            String value = LoadTACPN.getAttribute(node, "value").getNodeValue();
            Node intRangeElement = LoadTACPN.skipWS(node.getFirstChild());
            String start = LoadTACPN.getAttribute(intRangeElement, "start").getNodeValue();
            String end = LoadTACPN.getAttribute(intRangeElement, "end").getNodeValue();
            return new UserOperatorExpression(this.findColorForIntRange(value, start, end));
        }
        throw new FormatException(String.format("Could not parse %s as an color expression\n", name));
    }

    private Color getColor(String colorname) throws FormatException {
        for (ColorType ct : this.colortypes.values()) {
            for (Color c : ct) {
                if (!c.getName().equals(colorname)) continue;
                return c;
            }
        }
        throw new FormatException(String.format("The color \"%s\" was not declared\n", colorname));
    }

    public GuardExpression parseGuardExpression(Node node) throws FormatException {
        String name = node.getNodeName();
        if (name.matches("lt|lessthan")) {
            Tuple<ColorExpression, ColorExpression> subexps = this.parseLRColorExpressions(node);
            return new LessThanExpression(subexps.value1(), subexps.value2());
        }
        if (name.matches("gt|greaterthan")) {
            Tuple<ColorExpression, ColorExpression> subexps = this.parseLRColorExpressions(node);
            return new GreaterThanExpression(subexps.value1(), subexps.value2());
        }
        if (name.matches("leq|lessthanorequal")) {
            Tuple<ColorExpression, ColorExpression> subexps = this.parseLRColorExpressions(node);
            return new LessThanEqExpression(subexps.value1(), subexps.value2());
        }
        if (name.matches("geq|greaterthanorequal")) {
            Tuple<ColorExpression, ColorExpression> subexps = this.parseLRColorExpressions(node);
            return new GreaterThanEqExpression(subexps.value1(), subexps.value2());
        }
        if (name.matches("eq|equality")) {
            Tuple<ColorExpression, ColorExpression> subexps = this.parseLRColorExpressions(node);
            return new EqualityExpression(subexps.value1(), subexps.value2());
        }
        if (name.matches("neq|inequality")) {
            Tuple<ColorExpression, ColorExpression> subexps = this.parseLRColorExpressions(node);
            return new InequalityExpression(subexps.value1(), subexps.value2());
        }
        if (name.equals("not")) {
            Node child = LoadTACPN.skipWS(node.getFirstChild());
            GuardExpression childexp = this.parseGuardExpression(child);
            return new NotExpression(childexp);
        }
        if (name.equals("and")) {
            Tuple<GuardExpression, GuardExpression> subexps = this.parseLRGuardExpressions(node);
            AndExpression andExpr = new AndExpression(subexps.value1(), subexps.value2());
            Node isSimpleNode = node.getAttributes().getNamedItem("isSimple");
            if (isSimpleNode != null) {
                andExpr.setSimpleProperty(Boolean.parseBoolean(isSimpleNode.getNodeValue()));
            }
            return andExpr;
        }
        if (name.equals("or")) {
            Node left = LoadTACPN.skipWS(node.getFirstChild());
            Node right = LoadTACPN.skipWS(left.getNextSibling());
            if (right == null) {
                return this.parseGuardExpression(left);
            }
            OrExpression orExpr = new OrExpression(this.parseGuardExpression(left), this.parseGuardExpression(right));
            Node isSimpleNode = node.getAttributes().getNamedItem("isSimple");
            if (isSimpleNode != null) {
                orExpr.setSimpleProperty(Boolean.parseBoolean(isSimpleNode.getNodeValue()));
            }
            Node it = LoadTACPN.skipWS(right.getNextSibling());
            while (it != null) {
                orExpr = new OrExpression(orExpr, this.parseGuardExpression(it));
                it = LoadTACPN.skipWS(it.getNextSibling());
            }
            return orExpr;
        }
        if (name.matches("subterm|structure")) {
            Node child = LoadTACPN.skipWS(node.getFirstChild());
            return this.parseGuardExpression(child);
        }
        throw new FormatException(String.format("Could not parse %s as a guard expression\n", name));
    }

    private Tuple<ColorExpression, ColorExpression> parseLRColorExpressions(Node node) throws FormatException {
        Node left = LoadTACPN.skipWS(node.getFirstChild());
        ColorExpression leftexp = this.parseColorExpression(left);
        Node right = LoadTACPN.skipWS(left.getNextSibling());
        ColorExpression rightexp = this.parseColorExpression(right);
        return new Tuple<ColorExpression, ColorExpression>(leftexp, rightexp);
    }

    private Tuple<GuardExpression, GuardExpression> parseLRGuardExpressions(Node node) throws FormatException {
        Node left = LoadTACPN.skipWS(node.getFirstChild());
        GuardExpression leftexp = this.parseGuardExpression(left);
        Node right = LoadTACPN.skipWS(left.getNextSibling());
        GuardExpression rightexp = this.parseGuardExpression(right);
        return new Tuple<GuardExpression, GuardExpression>(leftexp, rightexp);
    }

    Color findColorForIntRange(String value, String start, String end) throws FormatException {
        for (ColorType ct : this.colortypes.values()) {
            List<Color> colors = ct.getColorList();
            if (colors.size() == 0 || !colors.get(0).getColorName().equals(start) || !colors.get(colors.size() - 1).getColorName().equals(end)) continue;
            for (Color c : ct) {
                if (!c.getName().equals(value)) continue;
                return c;
            }
        }
        throw new FormatException(String.format("The color \"%s\" was not declared in an int range\n", value));
    }

    public AddExpression constructCleanAddExpression(ArcExpression originalExpression) {
        if (originalExpression instanceof AddExpression) {
            return (AddExpression)originalExpression.deepCopy();
        }
        Vector<ArcExpression> cleaned = new Vector<ArcExpression>();
        cleaned.add(this.cleanArcExpression(originalExpression));
        return new AddExpression(cleaned);
    }

    private ArcExpression cleanArcExpression(ArcExpression expr) {
        if (expr instanceof NumberOfExpression) {
            NumberOfExpression noe = (NumberOfExpression)expr;
            Vector<ColorExpression> cleanedColors = new Vector<ColorExpression>();
            for (ColorExpression ce : noe.getColor()) {
                cleanedColors.add(this.cleanColorExpression(ce));
            }
            return new NumberOfExpression(noe.getNumber(), cleanedColors);
        }
        if (expr instanceof SubtractExpression) {
            SubtractExpression se = (SubtractExpression)expr;
            return new SubtractExpression(this.cleanArcExpression(se.getLeftExpression()), this.cleanArcExpression(se.getRightExpression()));
        }
        if (expr instanceof ScalarProductExpression) {
            ScalarProductExpression spe = (ScalarProductExpression)expr;
            return new ScalarProductExpression(spe.getScalar(), this.cleanArcExpression(spe.getExpr()));
        }
        return expr;
    }

    private ColorExpression cleanColorExpression(ColorExpression ce) {
        if (ce instanceof TupleExpression) {
            Vector<ColorExpression> cleaned = new Vector<ColorExpression>();
            for (ColorExpression sub : ((TupleExpression)ce).getColors()) {
                cleaned.add(this.cleanColorExpression(sub));
            }
            return new TupleExpression(cleaned);
        }
        return ce;
    }
}

