/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.approximation;

import dk.aau.cs.approximation.ITAPNApproximation;
import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import java.util.ArrayList;
import java.util.Iterator;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.Transition;

public class UnderApproximation
implements ITAPNApproximation {
    @Override
    public void modifyTAPN(TimedArcPetriNet net, int approximationDenominator) {
        this.modifyTAPN(net, approximationDenominator, null);
    }

    public void modifyTAPN(TimedArcPetriNet net, int approximationDenominator, DataLayer guiModel) {
        TimeInterval newInterval;
        Iterator<ColoredTimeInvariant> oldInterval;
        ArrayList<ColoredTimeInterval> newIntervals;
        ArrayList<TimedTransition> transitionsToDelete = new ArrayList<TimedTransition>();
        for (TimedInputArc timedInputArc : net.inputArcs()) {
            newIntervals = new ArrayList<ColoredTimeInterval>();
            for (ColoredTimeInterval interval : timedInputArc.getColorTimeIntervals()) {
                ColoredTimeInterval newInterval2 = (ColoredTimeInterval)this.modifyIntervals(interval, approximationDenominator);
                if (newInterval2 != null) {
                    newIntervals.add(newInterval2);
                    continue;
                }
                if (transitionsToDelete.contains(timedInputArc.destination())) continue;
                transitionsToDelete.add(timedInputArc.destination());
            }
            timedInputArc.setColorTimeIntervals(newIntervals);
            oldInterval = timedInputArc.interval();
            newInterval = this.modifyIntervals((TimeInterval)((Object)oldInterval), approximationDenominator);
            if (newInterval != null) {
                timedInputArc.setTimeInterval(newInterval);
                continue;
            }
            if (transitionsToDelete.contains(timedInputArc.destination())) continue;
            transitionsToDelete.add(timedInputArc.destination());
        }
        for (TransportArc transportArc : net.transportArcs()) {
            newIntervals = new ArrayList();
            for (ColoredTimeInterval interval : transportArc.getColorTimeIntervals()) {
                ColoredTimeInterval newInterval2 = (ColoredTimeInterval)this.modifyIntervals(interval, approximationDenominator);
                if (newInterval2 != null) {
                    newIntervals.add(newInterval2);
                    continue;
                }
                if (transitionsToDelete.contains(transportArc.transition())) continue;
                transitionsToDelete.add(transportArc.transition());
            }
            transportArc.setColorTimeIntervals(newIntervals);
            oldInterval = transportArc.interval();
            newInterval = this.modifyIntervals((TimeInterval)((Object)oldInterval), approximationDenominator);
            if (newInterval != null) {
                transportArc.setTimeInterval(newInterval);
                continue;
            }
            if (transitionsToDelete.contains(transportArc.transition())) continue;
            transitionsToDelete.add(transportArc.transition());
        }
        for (TimedTransition timedTransition : transitionsToDelete) {
            if (guiModel != null) {
                this.deleteTransitionFromGuiModel(timedTransition, guiModel);
            } else {
                this.deleteArcsFromTransition(timedTransition);
            }
            timedTransition.delete();
        }
        for (TimedPlace timedPlace : net.places()) {
            ArrayList<ColoredTimeInvariant> newInvariants = new ArrayList<ColoredTimeInvariant>();
            for (ColoredTimeInvariant cti : timedPlace.getCtiList()) {
                if (cti.upperBound() instanceof Bound.InfBound || cti.upperBound().value() <= 0) continue;
                int newInvariantBound = (int)Math.ceil((double)cti.upperBound().value() / (double)approximationDenominator);
                newInvariants.add(new ColoredTimeInvariant(cti.isUpperNonstrict(), new IntBound(newInvariantBound), cti.getColor()));
            }
            timedPlace.setCtiList(newInvariants);
            if (timedPlace.invariant().upperBound() instanceof Bound.InfBound || timedPlace.invariant().upperBound().value() <= 0) continue;
            TimeInvariant oldInvariant = timedPlace.invariant();
            int newInvariantBound = (int)Math.floor((double)oldInvariant.upperBound().value() / (double)approximationDenominator);
            timedPlace.setInvariant(new TimeInvariant(oldInvariant.isUpperNonstrict(), new IntBound(newInvariantBound)));
        }
    }

    private void deleteTransitionFromGuiModel(TimedTransition transitionToDelete, DataLayer guiModel) {
        Transition guiTransition = guiModel.getTransitionByName(transitionToDelete.name());
        for (Arc arc1 : guiModel.getArcs()) {
            if (arc1.getTarget() instanceof Place && arc1.getSource() == guiTransition) {
                guiModel.removePetriNetObject(arc1);
                continue;
            }
            if (!(arc1.getTarget() instanceof Transition) || arc1.getTarget() != guiTransition) continue;
            guiModel.removePetriNetObject(arc1);
        }
        guiModel.removePetriNetObject(guiTransition);
    }

    private void deleteArcsFromTransition(TimedTransition transitionToDelete) {
        ArrayList<TimedInputArc> inputArcs = new ArrayList<TimedInputArc>();
        for (TimedInputArc timedInputArc : transitionToDelete.getInputArcs()) {
            inputArcs.add(timedInputArc);
        }
        for (TimedInputArc timedInputArc : inputArcs) {
            timedInputArc.delete();
        }
        ArrayList<TimedOutputArc> outputArcs = new ArrayList<TimedOutputArc>();
        for (TimedOutputArc timedOutputArc : transitionToDelete.getOutputArcs()) {
            outputArcs.add(timedOutputArc);
        }
        for (TimedOutputArc timedOutputArc : outputArcs) {
            timedOutputArc.delete();
        }
        ArrayList<TransportArc> arrayList = new ArrayList<TransportArc>();
        for (TransportArc arc : transitionToDelete.getTransportArcsGoingThrough()) {
            arrayList.add(arc);
        }
        for (TransportArc arc : arrayList) {
            arc.delete();
        }
        ArrayList<TimedInhibitorArc> arrayList2 = new ArrayList<TimedInhibitorArc>();
        for (TimedInhibitorArc arc : transitionToDelete.getInhibitorArcs()) {
            arrayList2.add(arc);
        }
        for (TimedInhibitorArc arc : arrayList2) {
            arc.delete();
        }
    }

    private TimeInterval modifyIntervals(TimeInterval oldInterval, int denominator) {
        Bound newUpperBound;
        if (!(oldInterval.upperBound() instanceof Bound.InfBound)) {
            int oldUpperBoundValue = oldInterval.upperBound().value();
            newUpperBound = new IntBound((int)Math.floor((double)oldUpperBoundValue / (double)denominator));
        } else {
            newUpperBound = Bound.Infinity;
        }
        IntBound newLowerBound = new IntBound((int)Math.ceil((double)oldInterval.lowerBound().value() / (double)denominator));
        if (!(oldInterval.upperBound() instanceof Bound.InfBound) && newLowerBound.value() > newUpperBound.value()) {
            newLowerBound = new IntBound((int)Math.floor((double)oldInterval.lowerBound().value() / (double)denominator));
            newUpperBound = new IntBound((int)Math.floor((double)oldInterval.upperBound().value() / (double)denominator));
        }
        boolean isLowerBoundNonStrict = oldInterval.isLowerBoundNonStrict();
        boolean isUpperBoundNonStrict = oldInterval.isUpperBoundNonStrict();
        if (!(newUpperBound.value() != newLowerBound.value() || oldInterval.isLowerBoundNonStrict() && oldInterval.isUpperBoundNonStrict())) {
            isUpperBoundNonStrict = true;
            isLowerBoundNonStrict = true;
        }
        if (oldInterval instanceof ColoredTimeInterval) {
            return new ColoredTimeInterval(isLowerBoundNonStrict, newLowerBound, newUpperBound, isUpperBoundNonStrict, ((ColoredTimeInterval)oldInterval).getColor());
        }
        return new TimeInterval(isLowerBoundNonStrict, newLowerBound, newUpperBound, isUpperBoundNonStrict);
    }
}

