/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.approximation;

import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAndListNode;
import dk.aau.cs.TCTL.TCTLAtomicPropositionNode;
import dk.aau.cs.TCTL.TCTLConstNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.TCTL.TCTLNotNode;
import dk.aau.cs.TCTL.TCTLOrListNode;
import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.approximation.ITAPNApproximation;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTimeDelayStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTimedTransitionStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTraceStep;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.VerificationResult;
import java.util.ArrayList;
import java.util.HashMap;

public class OverApproximation
implements ITAPNApproximation {
    @Override
    public void modifyTAPN(TimedArcPetriNet net, int approximationDenominator) {
        TimeInterval newInterval;
        Object oldInterval;
        ArrayList<ColoredTimeInterval> newIntervals;
        for (TimedInputArc timedInputArc : net.inputArcs()) {
            newIntervals = new ArrayList<ColoredTimeInterval>();
            for (ColoredTimeInterval cti : timedInputArc.getColorTimeIntervals()) {
                newIntervals.add((ColoredTimeInterval)this.modifyIntervals(cti, approximationDenominator));
            }
            timedInputArc.setColorTimeIntervals(newIntervals);
            oldInterval = timedInputArc.interval();
            newInterval = this.modifyIntervals((TimeInterval)oldInterval, approximationDenominator);
            timedInputArc.setTimeInterval(newInterval);
        }
        for (TransportArc transportArc : net.transportArcs()) {
            newIntervals = new ArrayList();
            for (ColoredTimeInterval cti : transportArc.getColorTimeIntervals()) {
                newIntervals.add((ColoredTimeInterval)this.modifyIntervals(cti, approximationDenominator));
            }
            transportArc.setColorTimeIntervals(newIntervals);
            oldInterval = transportArc.interval();
            newInterval = this.modifyIntervals((TimeInterval)oldInterval, approximationDenominator);
            transportArc.setTimeInterval(newInterval);
        }
        for (TimedPlace timedPlace : net.places()) {
            ArrayList<ColoredTimeInvariant> newInvariants = new ArrayList<ColoredTimeInvariant>();
            for (ColoredTimeInvariant cti : timedPlace.getCtiList()) {
                if (cti.upperBound() instanceof Bound.InfBound || cti.upperBound().value() <= 0) continue;
                int newInvariantBound = (int)Math.ceil((double)cti.upperBound().value() / (double)approximationDenominator);
                newInvariants.add(new ColoredTimeInvariant(cti.isUpperNonstrict(), new IntBound(newInvariantBound), cti.getColor()));
            }
            timedPlace.setCtiList(newInvariants);
            if (timedPlace.invariant().upperBound() instanceof Bound.InfBound || timedPlace.invariant().upperBound().value() <= 0) continue;
            TimeInvariant oldInvariant = timedPlace.invariant();
            int newInvariantBound = (int)Math.ceil((double)oldInvariant.upperBound().value() / (double)approximationDenominator);
            timedPlace.setInvariant(new TimeInvariant(oldInvariant.isUpperNonstrict(), new IntBound(newInvariantBound)));
        }
    }

    private TimeInterval modifyIntervals(TimeInterval oldInterval, int denominator) {
        Bound newUpperBound;
        if (!(oldInterval.upperBound() instanceof Bound.InfBound)) {
            int oldUpperBoundValue = oldInterval.upperBound().value();
            newUpperBound = new IntBound((int)Math.ceil((double)oldUpperBoundValue / (double)denominator));
        } else {
            newUpperBound = Bound.Infinity;
        }
        IntBound newLowerBound = new IntBound((int)Math.floor(oldInterval.lowerBound().value() / denominator));
        if (oldInterval instanceof ColoredTimeInterval) {
            ColoredTimeInterval oldColoredInterval = (ColoredTimeInterval)oldInterval;
            return new ColoredTimeInterval(oldColoredInterval.isLowerBoundNonStrict(), newLowerBound, newUpperBound, oldColoredInterval.isUpperBoundNonStrict(), oldColoredInterval.getColor());
        }
        return new TimeInterval(oldInterval.isLowerBoundNonStrict(), newLowerBound, newUpperBound, oldInterval.isUpperBoundNonStrict());
    }

    /*
     * WARNING - void declaration
     */
    public void makeTraceTAPN(Tuple<TimedArcPetriNet, NameMapping> transformedModel, VerificationResult<TAPNNetworkTrace> result, TAPNQuery query) {
        TimedArcPetriNet net = transformedModel.value1();
        LocalTimedPlace currentPlace = new LocalTimedPlace("PTRACE0");
        TimedToken currentToken = new TimedToken(currentPlace, ColorType.COLORTYPE_DOT.getFirstColor());
        net.add(currentPlace);
        currentPlace.addToken(currentToken);
        LocalTimedPlace blockPlace = new LocalTimedPlace("PBLOCK");
        TimedToken blockToken = new TimedToken(blockPlace, ColorType.COLORTYPE_DOT.getFirstColor());
        net.add(blockPlace);
        blockPlace.addToken(blockToken);
        ArrayList<TimedTransition> originalTransitions = new ArrayList<TimedTransition>();
        for (TimedTransition timedTransition : net.transitions()) {
            originalTransitions.add(timedTransition);
        }
        ArrayList<TimedInputArc> originalInput = new ArrayList<TimedInputArc>();
        for (TimedInputArc timedInputArc : net.inputArcs()) {
            originalInput.add(timedInputArc);
        }
        ArrayList<TimedOutputArc> arrayList = new ArrayList<TimedOutputArc>();
        for (TimedOutputArc timedOutputArc : net.outputArcs()) {
            arrayList.add(timedOutputArc);
        }
        ArrayList<TimedInhibitorArc> arrayList2 = new ArrayList<TimedInhibitorArc>();
        for (TimedInhibitorArc timedInhibitorArc : net.inhibitorArcs()) {
            arrayList2.add(timedInhibitorArc);
        }
        ArrayList<TransportArc> arrayList3 = new ArrayList<TransportArc>();
        for (TransportArc transport : net.transportArcs()) {
            arrayList3.add(transport);
        }
        boolean bl = false;
        int transitionInteger = 0;
        TimedOutputArc next = null;
        boolean traceHasTransitionStep = false;
        TAPNNetworkTrace trace = result.getTrace();
        HashMap<Tuple<String, String>, String> nameMap = transformedModel.value2().getOrgToMapped();
        LocalTimedPlace loopStep = null;
        boolean delayIsLoopStep = false;
        for (TAPNNetworkTraceStep step : trace) {
            void var14_23;
            if (step instanceof TAPNNetworkTimeDelayStep && step.isLoopStep()) {
                delayIsLoopStep = true;
            }
            if (!(step instanceof TAPNNetworkTimedTransitionStep)) continue;
            TAPNNetworkTimedTransitionStep tmpStep = (TAPNNetworkTimedTransitionStep)step;
            Tuple<String, String> key = new Tuple<String, String>(((TAPNNetworkTimedTransitionStep)step).getTransition().sharedTransition() == null ? tmpStep.getTransition().model().name() : "", tmpStep.getTransition().name());
            TimedTransition firedTransition = net.getTransitionByName(nameMap.get(key));
            TimedTransition copyTransition = new TimedTransition(firedTransition.name() + "_traceNet_" + Integer.toString(++transitionInteger), firedTransition.isUrgent(), null);
            net.add(copyTransition);
            net.add(new TimedInputArc(currentPlace, copyTransition, TimeInterval.ZERO_INF));
            net.add(new TimedInputArc(blockPlace, copyTransition, TimeInterval.ZERO_INF));
            net.add(new TimedOutputArc(copyTransition, blockPlace));
            if (step.isLoopStep() || delayIsLoopStep) {
                loopStep = currentPlace;
                delayIsLoopStep = false;
            }
            currentPlace = new LocalTimedPlace("PTRACE" + Integer.toString((int)(++var14_23)));
            net.add(currentPlace);
            next = new TimedOutputArc(copyTransition, currentPlace);
            net.add(next);
            for (TimedInputArc timedInputArc : originalInput) {
                if (timedInputArc.destination() != firedTransition) continue;
                net.add(new TimedInputArc(timedInputArc.source(), copyTransition, timedInputArc.interval(), timedInputArc.getWeight(), timedInputArc.getArcExpression()));
            }
            for (TimedOutputArc timedOutputArc : arrayList) {
                if (timedOutputArc.source() != firedTransition) continue;
                net.add(new TimedOutputArc(copyTransition, timedOutputArc.destination(), timedOutputArc.getWeight(), timedOutputArc.getExpression()));
            }
            for (TimedInhibitorArc timedInhibitorArc : arrayList2) {
                if (timedInhibitorArc.destination() != firedTransition) continue;
                net.add(new TimedInhibitorArc(timedInhibitorArc.source(), copyTransition, timedInhibitorArc.interval(), timedInhibitorArc.getWeight(), timedInhibitorArc.getArcExpression()));
            }
            for (TransportArc transportArc : arrayList3) {
                if (transportArc.transition() != firedTransition) continue;
                net.add(new TransportArc(transportArc.source(), copyTransition, transportArc.destination(), transportArc.interval(), transportArc.getWeight(), transportArc.getInputExpression(), transportArc.getOutputExpression()));
            }
            traceHasTransitionStep = true;
        }
        if (loopStep != null) {
            net.add(new TimedOutputArc(next.source(), loopStep));
        }
        if (traceHasTransitionStep) {
            net.remove(next);
            net.remove(currentPlace);
        }
        this.modifyQuery(query, blockPlace);
        for (TimedTransition transition : originalTransitions) {
            net.add(new TimedInputArc(blockPlace, transition, TimeInterval.ZERO_INF));
        }
    }

    private void modifyQuery(TAPNQuery query, LocalTimedPlace blockPlace) {
        TCTLAbstractProperty topNode = query.getProperty();
        TCTLAtomicPropositionNode pBlock = new TCTLAtomicPropositionNode(new TCTLPlaceNode(blockPlace.name()), "=", new TCTLConstNode(1));
        if (topNode instanceof TCTLEFNode) {
            if (((TCTLEFNode)topNode).getProperty() instanceof TCTLAndListNode) {
                ((TCTLAndListNode)((TCTLEFNode)topNode).getProperty()).addConjunct(pBlock);
            } else {
                TCTLAndListNode andList = new TCTLAndListNode(((TCTLEFNode)topNode).getProperty(), pBlock);
                ((TCTLEFNode)topNode).setProperty(andList);
            }
        } else if (topNode instanceof TCTLAGNode) {
            TCTLNotNode notNode = new TCTLNotNode(pBlock);
            if (((TCTLAGNode)topNode).getProperty() instanceof TCTLOrListNode) {
                ((TCTLOrListNode)((TCTLAGNode)topNode).getProperty()).addDisjunct(notNode);
            } else {
                TCTLOrListNode orList = new TCTLOrListNode(((TCTLAGNode)topNode).getProperty(), notNode);
                ((TCTLAGNode)topNode).setProperty(orList);
            }
        } else if (topNode instanceof TCTLEGNode) {
            if (((TCTLEGNode)topNode).getProperty() instanceof TCTLAndListNode) {
                ((TCTLAndListNode)((TCTLEGNode)topNode).getProperty()).addConjunct(pBlock);
            } else {
                TCTLAndListNode andList = new TCTLAndListNode(((TCTLEGNode)topNode).getProperty(), pBlock);
                ((TCTLEGNode)topNode).setProperty(andList);
            }
        } else if (topNode instanceof TCTLAFNode) {
            TCTLNotNode notNode = new TCTLNotNode(pBlock);
            if (((TCTLAFNode)topNode).getProperty() instanceof TCTLOrListNode) {
                ((TCTLOrListNode)((TCTLAFNode)topNode).getProperty()).addDisjunct(notNode);
            } else {
                TCTLOrListNode orList = new TCTLOrListNode(((TCTLAFNode)topNode).getProperty(), notNode);
                ((TCTLAFNode)topNode).setProperty(orList);
            }
        }
    }
}

