/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.approximation;

import dk.aau.cs.Messenger;
import dk.aau.cs.approximation.OverApproximation;
import dk.aau.cs.approximation.UnderApproximation;
import dk.aau.cs.io.batchProcessing.LoadedBatchProcessingModel;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.simulation.PetriNetStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.TimeDelayStep;
import dk.aau.cs.model.tapn.simulation.TimedArcPetriNetTrace;
import dk.aau.cs.model.tapn.simulation.TimedTransitionStep;
import dk.aau.cs.util.MemoryMonitor;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.ITAPNComposer;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.QueryType;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.TAPNTraceDecomposer;
import dk.aau.cs.verification.VerificationOptions;
import dk.aau.cs.verification.VerificationResult;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOptions;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.RunVerificationBase;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.petrinet.dataLayer.DataLayer;

public class ApproximationWorker {
    public VerificationResult<TAPNNetworkTrace> normalWorker(VerificationOptions options, ModelChecker modelChecker, Tuple<TimedArcPetriNet, NameMapping> transformedModel, ITAPNComposer composer, TAPNQuery clonedQuery, RunVerificationBase verificationBase, TimedArcPetriNetNetwork model, DataLayer guiModel, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) throws Exception {
        boolean isColored = lens != null && lens.isColored() || model.isColored();
        InclusionPlaces oldInclusionPlaces = null;
        if (options instanceof VerifyTAPNOptions) {
            oldInclusionPlaces = ((VerifyTAPNOptions)options).inclusionPlaces();
        }
        TAPNQuery.TraceOption oldTraceOption = options.traceOption();
        if (options.enabledOverApproximation() || options.enabledUnderApproximation()) {
            options.setTraceOption(TAPNQuery.TraceOption.SOME);
        }
        VerificationResult<TAPNNetworkTrace> toReturn = null;
        VerificationResult<TimedArcPetriNetTrace> result = modelChecker.verify(options, transformedModel, clonedQuery, guiModel, dataLayerQuery, lens);
        if (result == null) {
            return null;
        }
        if (result.error()) {
            options.setTraceOption(oldTraceOption);
            return new VerificationResult<TAPNNetworkTrace>(result.errorMessage(), result.verificationTime());
        }
        if (options.enabledOverApproximation()) {
            if (options.approximationDenominator() == 1) {
                QueryResult queryResult = result.getQueryResult();
                NameMapping nameMapping = isColored ? result.getUnfoldedModel().value2() : transformedModel.value2();
                TimedArcPetriNetNetwork netNetwork = isColored ? result.getUnfoldedModel().value1().parentNetwork() : model;
                toReturn = new VerificationResult<TAPNNetworkTrace>(queryResult, this.decomposeTrace(result.getTrace(), nameMapping, netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, netNetwork), result.verificationTime(), result.stats(), false, result.getRawOutput(), result.getUnfoldedModel(), result.getUnfoldedTab());
                toReturn.setNameMapping(transformedModel.value2());
            } else if (result.getTrace() != null && ((result.getQueryResult().queryType() == QueryType.EF || result.getQueryResult().queryType() == QueryType.EG) && result.getQueryResult().isQuerySatisfied() || (result.getQueryResult().queryType() == QueryType.AG || result.getQueryResult().queryType() == QueryType.AF) && !result.getQueryResult().isQuerySatisfied())) {
                VerificationResult<TimedArcPetriNetTrace> approxResult = result;
                NameMapping nameMapping = isColored ? result.getUnfoldedModel().value2() : transformedModel.value2();
                TimedArcPetriNetNetwork netNetwork = isColored ? result.getUnfoldedModel().value1().parentNetwork() : model;
                toReturn = new VerificationResult<TAPNNetworkTrace>(result.getQueryResult(), this.decomposeTrace(result.getTrace(), nameMapping, netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, netNetwork), result.verificationTime(), result.stats(), false, result.getRawOutput(), result.getUnfoldedModel(), result.getUnfoldedTab());
                toReturn.setNameMapping(nameMapping);
                OverApproximation overaprx = new OverApproximation();
                Tuple<TimedArcPetriNet, NameMapping> transformedOriginalModel = composer.transformModel(model);
                VerificationResult<TimedArcPetriNetTrace> unfoldedResult = null;
                if (isColored) {
                    unfoldedResult = modelChecker.verify(options, transformedOriginalModel, clonedQuery, composer.getGuiModel(), dataLayerQuery, lens);
                    if (unfoldedResult.getTrace() == null) {
                        options.setTraceOption(oldTraceOption);
                        QueryResult queryResult = unfoldedResult.getQueryResult();
                        if ((unfoldedResult.getQueryResult().queryType() == QueryType.EF || unfoldedResult.getQueryResult().queryType() == QueryType.EG) && !queryResult.isQuerySatisfied() || (unfoldedResult.getQueryResult().queryType() == QueryType.AG || unfoldedResult.getQueryResult().queryType() == QueryType.AF) && queryResult.isQuerySatisfied()) {
                            queryResult.setApproximationInconclusive(true);
                        }
                        if ((toReturn = new VerificationResult<TAPNNetworkTrace>(queryResult, this.decomposeTrace(result.getTrace(), nameMapping, netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, netNetwork), result.verificationTime() + unfoldedResult.verificationTime(), unfoldedResult.stats(), false, unfoldedResult.getRawOutput(), unfoldedResult.getUnfoldedModel(), null)) != null) {
                            toReturn.setTrace(null);
                            toReturn.setSecondaryTrace(null);
                        }
                        return toReturn;
                    }
                    nameMapping = unfoldedResult.getUnfoldedModel().value2();
                    netNetwork = unfoldedResult.getUnfoldedModel().value1().parentNetwork();
                    transformedOriginalModel = unfoldedResult.getUnfoldedModel();
                    dataLayerQuery = unfoldedResult.getUnfoldedTab().queries().iterator().next();
                    clonedQuery = new TAPNQuery(dataLayerQuery.getProperty(), dataLayerQuery.getCapacity());
                    ((VerifyTAPNOptions)options).setUnfold(false);
                }
                overaprx.makeTraceTAPN(transformedOriginalModel, toReturn, clonedQuery);
                if (options instanceof VerifyTAPNOptions && oldInclusionPlaces != null) {
                    ((VerifyTAPNOptions)options).setInclusionPlaces(oldInclusionPlaces);
                }
                MemoryMonitor.cumulateMemory();
                result = modelChecker.verify(options, transformedOriginalModel, clonedQuery, null, dataLayerQuery, null);
                if (result.error()) {
                    options.setTraceOption(oldTraceOption);
                    if (oldTraceOption == TAPNQuery.TraceOption.NONE && toReturn != null) {
                        toReturn.setTrace(null);
                        toReturn.setSecondaryTrace(null);
                    }
                    return new VerificationResult<TAPNNetworkTrace>(result.errorMessage(), approxResult.verificationTime() + result.verificationTime());
                }
                this.renameTraceTransitions(result.getTrace());
                this.renameTraceTransitions(result.getSecondaryTrace());
                QueryResult queryResult = result.getQueryResult();
                if ((result.getQueryResult().queryType() == QueryType.EF || result.getQueryResult().queryType() == QueryType.EG) && !queryResult.isQuerySatisfied() || (result.getQueryResult().queryType() == QueryType.AG || result.getQueryResult().queryType() == QueryType.AF) && queryResult.isQuerySatisfied()) {
                    queryResult.setApproximationInconclusive(true);
                }
                if (unfoldedResult != null) {
                    unfoldedResult.getUnfoldedTab().getQueryPane().setQueries(approxResult.getUnfoldedTab().queries());
                    toReturn = new VerificationResult<TAPNNetworkTrace>(queryResult, this.decomposeTrace(result.getTrace(), nameMapping, netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, netNetwork), approxResult.verificationTime() + unfoldedResult.verificationTime() + result.verificationTime(), approxResult.stats(), false, unfoldedResult.getRawOutput(), unfoldedResult.getUnfoldedModel(), unfoldedResult.getUnfoldedTab());
                    toReturn.setNameMapping(nameMapping);
                } else {
                    toReturn = new VerificationResult<TAPNNetworkTrace>(queryResult, this.decomposeTrace(result.getTrace(), nameMapping, netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, netNetwork), approxResult.verificationTime() + result.verificationTime(), approxResult.stats(), false, approxResult.getRawOutput(), approxResult.getUnfoldedModel(), approxResult.getUnfoldedTab());
                    toReturn.setNameMapping(nameMapping);
                }
            } else if ((result.getQueryResult().queryType() == QueryType.EF || result.getQueryResult().queryType() == QueryType.EG) && !result.getQueryResult().isQuerySatisfied() || (result.getQueryResult().queryType() == QueryType.AG || result.getQueryResult().queryType() == QueryType.AF) && result.getQueryResult().isQuerySatisfied()) {
                QueryResult queryResult = result.getQueryResult();
                if (queryResult.hasDeadlock() || result.getQueryResult().queryType() == QueryType.EG || result.getQueryResult().queryType() == QueryType.AF) {
                    queryResult.setApproximationInconclusive(true);
                }
                NameMapping nameMapping = isColored ? result.getUnfoldedModel().value2() : transformedModel.value2();
                TimedArcPetriNetNetwork netNetwork = isColored ? result.getUnfoldedModel().value1().parentNetwork() : model;
                toReturn = new VerificationResult<TAPNNetworkTrace>(result.getQueryResult(), this.decomposeTrace(result.getTrace(), nameMapping, netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, netNetwork), result.verificationTime(), result.stats(), false, result.getRawOutput(), result.getUnfoldedModel(), result.getUnfoldedTab());
                toReturn.setNameMapping(nameMapping);
            } else {
                QueryResult queryResult = result.getQueryResult();
                queryResult.setApproximationInconclusive(true);
                NameMapping nameMapping = isColored ? result.getUnfoldedModel().value2() : transformedModel.value2();
                TimedArcPetriNetNetwork netNetwork = isColored ? result.getUnfoldedModel().value1().parentNetwork() : model;
                toReturn = new VerificationResult<TAPNNetworkTrace>(result.getQueryResult(), this.decomposeTrace(result.getTrace(), nameMapping, netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, netNetwork), result.verificationTime(), result.stats(), false, result.getRawOutput(), result.getUnfoldedModel(), result.getUnfoldedTab());
                toReturn.setNameMapping(nameMapping);
            }
        } else if (options.enabledUnderApproximation()) {
            Object netNetwork;
            NameMapping nameMapping;
            Object queryResult;
            if (result.getTrace() != null) {
                for (PetriNetStep k : result.getTrace()) {
                    if (k instanceof TimeDelayStep) {
                        ((TimeDelayStep)k).setDelay(((TimeDelayStep)k).delay().multiply(new BigDecimal(options.approximationDenominator())));
                        continue;
                    }
                    if (!(k instanceof TimedTransitionStep)) continue;
                    for (TimedToken a : ((TimedTransitionStep)k).consumedTokens()) {
                        a.setAge(a.age().multiply(new BigDecimal(options.approximationDenominator())));
                    }
                }
            }
            if (options.approximationDenominator() == 1) {
                queryResult = result.getQueryResult();
                nameMapping = isColored ? result.getUnfoldedModel().value2() : transformedModel.value2();
                netNetwork = isColored ? result.getUnfoldedModel().value1().parentNetwork() : model;
                toReturn = new VerificationResult<TAPNNetworkTrace>((QueryResult)queryResult, this.decomposeTrace(result.getTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), result.verificationTime(), result.stats(), false, result.getRawOutput(), result.getUnfoldedModel(), result.getUnfoldedTab());
                toReturn.setNameMapping(nameMapping);
            } else if ((result.getQueryResult().queryType() == QueryType.EF || result.getQueryResult().queryType() == QueryType.EG) && !result.getQueryResult().isQuerySatisfied() || (result.getQueryResult().queryType() == QueryType.AG || result.getQueryResult().queryType() == QueryType.AF) && result.getQueryResult().isQuerySatisfied()) {
                queryResult = result.getQueryResult();
                ((QueryResult)queryResult).setApproximationInconclusive(true);
                nameMapping = isColored ? result.getUnfoldedModel().value2() : transformedModel.value2();
                netNetwork = isColored ? result.getUnfoldedModel().value1().parentNetwork() : model;
                toReturn = new VerificationResult<TAPNNetworkTrace>((QueryResult)queryResult, this.decomposeTrace(result.getTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), result.verificationTime(), result.stats(), false, result.getRawOutput(), result.getUnfoldedModel(), result.getUnfoldedTab());
                toReturn.setNameMapping(nameMapping);
            } else if ((result.getQueryResult().queryType() == QueryType.EF || result.getQueryResult().queryType() == QueryType.EG) && result.getQueryResult().isQuerySatisfied() || (result.getQueryResult().queryType() == QueryType.AG || result.getQueryResult().queryType() == QueryType.AF) && !result.getQueryResult().isQuerySatisfied()) {
                if (result.getTrace() != null) {
                    VerificationResult<TimedArcPetriNetTrace> approxResult = result;
                    nameMapping = isColored || lens.isColored() ? result.getUnfoldedModel().value2() : transformedModel.value2();
                    netNetwork = isColored || lens.isColored() ? result.getUnfoldedModel().value1().parentNetwork() : model;
                    toReturn = new VerificationResult<TAPNNetworkTrace>(approxResult.getQueryResult(), this.decomposeTrace(approxResult.getTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), this.decomposeTrace(approxResult.getSecondaryTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), approxResult.verificationTime(), approxResult.stats(), false, approxResult.getRawOutput(), result.getUnfoldedModel(), result.getUnfoldedTab());
                    toReturn.setNameMapping(nameMapping);
                    OverApproximation overaprx = new OverApproximation();
                    Tuple<TimedArcPetriNet, NameMapping> transformedOriginalModel = composer.transformModel(model);
                    VerificationResult<TimedArcPetriNetTrace> unfoldedResult = null;
                    if (isColored) {
                        options.setTraceOption(oldTraceOption);
                        unfoldedResult = modelChecker.verify(options, transformedOriginalModel, clonedQuery, composer.getGuiModel(), dataLayerQuery, lens);
                        if (unfoldedResult.getTrace() == null) {
                            options.setTraceOption(oldTraceOption);
                            QueryResult queryResult2 = unfoldedResult.getQueryResult();
                            if ((unfoldedResult.getQueryResult().queryType() == QueryType.EF || unfoldedResult.getQueryResult().queryType() == QueryType.EG) && !queryResult2.isQuerySatisfied() || (unfoldedResult.getQueryResult().queryType() == QueryType.AG || unfoldedResult.getQueryResult().queryType() == QueryType.AF) && queryResult2.isQuerySatisfied()) {
                                queryResult2.setApproximationInconclusive(true);
                            }
                            toReturn = new VerificationResult<Object>(unfoldedResult.getQueryResult(), null, null, result.verificationTime() + unfoldedResult.verificationTime(), unfoldedResult.stats(), false, unfoldedResult.getRawOutput(), unfoldedResult.getUnfoldedModel(), null);
                            return toReturn;
                        }
                        nameMapping = unfoldedResult.getUnfoldedModel().value2();
                        netNetwork = unfoldedResult.getUnfoldedModel().value1().parentNetwork();
                        transformedOriginalModel = unfoldedResult.getUnfoldedModel();
                        dataLayerQuery = unfoldedResult.getUnfoldedTab().queries().iterator().next();
                        clonedQuery = new TAPNQuery(dataLayerQuery.getProperty(), dataLayerQuery.getCapacity());
                        ((VerifyTAPNOptions)options).setUnfold(false);
                    }
                    overaprx.makeTraceTAPN(transformedOriginalModel, toReturn, clonedQuery);
                    if (options instanceof VerifyTAPNOptions && oldInclusionPlaces != null) {
                        ((VerifyTAPNOptions)options).setInclusionPlaces(oldInclusionPlaces);
                    }
                    MemoryMonitor.cumulateMemory();
                    result = modelChecker.verify(options, transformedOriginalModel, clonedQuery, guiModel, dataLayerQuery, null);
                    if (result.error()) {
                        options.setTraceOption(oldTraceOption);
                        if (oldTraceOption == TAPNQuery.TraceOption.NONE && toReturn != null) {
                            toReturn.setTrace(null);
                            toReturn.setSecondaryTrace(null);
                        }
                        return new VerificationResult<TAPNNetworkTrace>(result.errorMessage(), result.verificationTime() + approxResult.verificationTime());
                    }
                    this.renameTraceTransitions(result.getTrace());
                    this.renameTraceTransitions(result.getSecondaryTrace());
                    QueryResult queryResult3 = result.getQueryResult();
                    if (result.getQueryResult().queryType() == QueryType.EF && !queryResult3.isQuerySatisfied() || result.getQueryResult().queryType() == QueryType.AG && queryResult3.isQuerySatisfied() || result.getQueryResult().queryType() == QueryType.EG && !queryResult3.isQuerySatisfied() || result.getQueryResult().queryType() == QueryType.AF && queryResult3.isQuerySatisfied()) {
                        queryResult3.setApproximationInconclusive(true);
                    }
                    if (unfoldedResult != null) {
                        unfoldedResult.getUnfoldedTab().getQueryPane().setQueries(approxResult.getUnfoldedTab().queries());
                        toReturn = new VerificationResult<TAPNNetworkTrace>(queryResult3, this.decomposeTrace(result.getTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), approxResult.verificationTime() + unfoldedResult.verificationTime() + result.verificationTime(), approxResult.stats(), false, unfoldedResult.getRawOutput(), unfoldedResult.getUnfoldedModel(), unfoldedResult.getUnfoldedTab());
                        toReturn.setNameMapping(nameMapping);
                    } else {
                        toReturn = new VerificationResult<TAPNNetworkTrace>(queryResult3, this.decomposeTrace(result.getTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), approxResult.verificationTime() + result.verificationTime(), approxResult.stats(), false, approxResult.getRawOutput(), approxResult.getUnfoldedModel(), approxResult.getUnfoldedTab());
                        toReturn.setNameMapping(nameMapping);
                    }
                } else {
                    queryResult = result.getQueryResult();
                    ((QueryResult)queryResult).setApproximationInconclusive(true);
                    nameMapping = isColored ? result.getUnfoldedModel().value2() : transformedModel.value2();
                    netNetwork = isColored ? result.getUnfoldedModel().value1().parentNetwork() : model;
                    toReturn = new VerificationResult<TAPNNetworkTrace>(result.getQueryResult(), this.decomposeTrace(result.getTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, (TimedArcPetriNetNetwork)netNetwork), result.verificationTime(), result.stats(), false, result.getRawOutput(), result.getUnfoldedModel(), result.getUnfoldedTab());
                    toReturn.setNameMapping(nameMapping);
                }
            }
        } else {
            TimedArcPetriNetNetwork netNetwork;
            NameMapping nameMapping = isColored ? result.getUnfoldedModel().value2() : transformedModel.value2();
            TimedArcPetriNetNetwork timedArcPetriNetNetwork = netNetwork = isColored ? result.getUnfoldedModel().value1().parentNetwork() : model;
            if (dataLayerQuery != null && dataLayerQuery.getCategory() == TAPNQuery.QueryCategory.HyperLTL || dataLayerQuery.getCategory() == TAPNQuery.QueryCategory.SMC) {
                toReturn = new VerificationResult<TAPNNetworkTrace>(result.getQueryResult(), this.decomposeTrace(result.getTraceMap(), nameMapping, netNetwork), this.decomposeTrace(result.getTrace(), nameMapping, netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, netNetwork), result.verificationTime(), result.stats(), false, result.getRawOutput(), result.getUnfoldedModel(), result.getUnfoldedTab());
                toReturn.setNameMapping(nameMapping);
            } else {
                toReturn = new VerificationResult<TAPNNetworkTrace>(result.getQueryResult(), this.decomposeTrace(result.getTrace(), nameMapping, netNetwork), this.decomposeTrace(result.getSecondaryTrace(), nameMapping, netNetwork), result.verificationTime(), result.stats(), false, result.getRawOutput(), result.getUnfoldedModel(), result.getUnfoldedTab());
                toReturn.setNameMapping(nameMapping);
            }
        }
        options.setTraceOption(oldTraceOption);
        if (oldTraceOption == TAPNQuery.TraceOption.NONE && toReturn != null && dataLayerQuery.getCategory() != TAPNQuery.QueryCategory.SMC) {
            toReturn.setTrace(null);
            toReturn.setSecondaryTrace(null);
        }
        return toReturn;
    }

    public VerificationResult<TimedArcPetriNetTrace> batchWorker(Tuple<TimedArcPetriNet, NameMapping> composedModel, VerificationOptions options, net.tapaal.gui.petrinet.verification.TAPNQuery query, LoadedBatchProcessingModel model, ModelChecker modelChecker, TAPNQuery queryToVerify, TAPNQuery clonedQuery) throws Exception {
        InclusionPlaces oldInclusionPlaces = null;
        if (options instanceof VerifyTAPNOptions) {
            oldInclusionPlaces = ((VerifyTAPNOptions)options).inclusionPlaces();
        }
        Tuple<TimedArcPetriNet, NameMapping> transformedOriginalModel = new Tuple<TimedArcPetriNet, NameMapping>(composedModel.value1().copy(), composedModel.value2());
        TAPNQuery.TraceOption oldTraceOption = options.traceOption();
        if (query != null && query.isOverApproximationEnabled()) {
            composedModel = this.composeModel(model);
            OverApproximation overaprx = new OverApproximation();
            overaprx.modifyTAPN(composedModel.value1(), query.approximationDenominator());
            options.setTraceOption(TAPNQuery.TraceOption.SOME);
        } else if (query != null && query.isUnderApproximationEnabled()) {
            composedModel = this.composeModel(model);
            UnderApproximation underaprx = new UnderApproximation();
            underaprx.modifyTAPN(composedModel.value1(), query.approximationDenominator());
            options.setTraceOption(TAPNQuery.TraceOption.SOME);
        }
        boolean modelIsColored = composedModel.value1().isColored();
        boolean modelIsTimed = !composedModel.value1().isUntimed();
        boolean modelIsGame = composedModel.value1().hasUncontrollableTransitions();
        boolean modelIsStochastic = composedModel.value1().isStochastic();
        TAPNLens lens = new TAPNLens(modelIsTimed, modelIsGame, modelIsColored, modelIsStochastic);
        VerificationResult<TimedArcPetriNetTrace> verificationResult = modelChecker.verify(options, composedModel, queryToVerify, null, query, lens);
        VerificationResult<TimedArcPetriNetTrace> value = null;
        if (verificationResult.error()) {
            options.setTraceOption(oldTraceOption);
            return new VerificationResult<TimedArcPetriNetTrace>(verificationResult.errorMessage(), verificationResult.verificationTime());
        }
        if (query != null && query.isOverApproximationEnabled()) {
            if (query.approximationDenominator() == 1) {
                QueryResult queryResult = verificationResult.getQueryResult();
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
                value.setNameMapping(composedModel.value2());
            } else if (verificationResult.getTrace() != null && ((verificationResult.getQueryResult().queryType() == QueryType.EF || verificationResult.getQueryResult().queryType() == QueryType.EG) && verificationResult.getQueryResult().isQuerySatisfied() || (verificationResult.getQueryResult().queryType() == QueryType.AG || verificationResult.getQueryResult().queryType() == QueryType.AF) && !verificationResult.getQueryResult().isQuerySatisfied())) {
                VerificationResult<TimedArcPetriNetTrace> approxResult = verificationResult;
                NameMapping nameMapping = model.network().isColored() ? verificationResult.getUnfoldedModel().value2() : composedModel.value2();
                TimedArcPetriNetNetwork netNetwork = model.network().isColored() ? verificationResult.getUnfoldedModel().value1().parentNetwork() : model.network();
                VerificationResult<TAPNNetworkTrace> valueNetwork = new VerificationResult<TAPNNetworkTrace>(approxResult.getQueryResult(), this.decomposeTrace(approxResult.getTrace(), nameMapping, netNetwork), this.decomposeTrace(approxResult.getSecondaryTrace(), nameMapping, netNetwork), approxResult.verificationTime(), approxResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
                valueNetwork.setNameMapping(nameMapping);
                OverApproximation overaprx = new OverApproximation();
                if (model.network().isColored()) {
                    transformedOriginalModel = approxResult.getUnfoldedModel();
                    net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery = approxResult.getUnfoldedTab().queries().iterator().next();
                    clonedQuery = new TAPNQuery(dataLayerQuery.getProperty(), dataLayerQuery.getCapacity());
                    ((VerifyTAPNOptions)options).setUnfold(false);
                }
                overaprx.makeTraceTAPN(transformedOriginalModel, valueNetwork, clonedQuery);
                if (options instanceof VerifyTAPNOptions && oldInclusionPlaces != null) {
                    ((VerifyTAPNOptions)options).setInclusionPlaces(oldInclusionPlaces);
                }
                MemoryMonitor.cumulateMemory();
                verificationResult = modelChecker.verify(options, transformedOriginalModel, clonedQuery, null, query, null);
                if (verificationResult.error()) {
                    options.setTraceOption(oldTraceOption);
                    return new VerificationResult<TimedArcPetriNetTrace>(verificationResult.errorMessage(), verificationResult.verificationTime() + approxResult.verificationTime());
                }
                this.renameTraceTransitions(verificationResult.getTrace());
                this.renameTraceTransitions(verificationResult.getSecondaryTrace());
                QueryResult queryResult = verificationResult.getQueryResult();
                if ((verificationResult.getQueryResult().queryType() == QueryType.EF || verificationResult.getQueryResult().queryType() == QueryType.EG) && !queryResult.isQuerySatisfied() || (verificationResult.getQueryResult().queryType() == QueryType.AG || verificationResult.getQueryResult().queryType() == QueryType.AF) && queryResult.isQuerySatisfied()) {
                    queryResult.setApproximationInconclusive(true);
                }
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, approxResult.getTrace(), approxResult.getSecondaryTrace(), approxResult.verificationTime() + verificationResult.verificationTime(), approxResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
                value.setNameMapping(composedModel.value2());
            } else if ((verificationResult.getQueryResult().queryType() == QueryType.EF || verificationResult.getQueryResult().queryType() == QueryType.EG) && !verificationResult.getQueryResult().isQuerySatisfied() || (verificationResult.getQueryResult().queryType() == QueryType.AG || verificationResult.getQueryResult().queryType() == QueryType.AF) && verificationResult.getQueryResult().isQuerySatisfied()) {
                QueryResult queryResult = verificationResult.getQueryResult();
                if (queryResult.hasDeadlock() || queryResult.queryType() == QueryType.EG || queryResult.queryType() == QueryType.AF) {
                    queryResult.setApproximationInconclusive(true);
                }
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
                value.setNameMapping(composedModel.value2());
            } else {
                QueryResult queryResult = verificationResult.getQueryResult();
                queryResult.setApproximationInconclusive(true);
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
                value.setNameMapping(composedModel.value2());
            }
        } else if (query != null && query.isUnderApproximationEnabled()) {
            if (query.approximationDenominator() == 1) {
                QueryResult queryResult = verificationResult.getQueryResult();
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
                value.setNameMapping(composedModel.value2());
            } else if ((verificationResult.getQueryResult().queryType() == QueryType.EF || verificationResult.getQueryResult().queryType() == QueryType.EG) && !verificationResult.getQueryResult().isQuerySatisfied() || (verificationResult.getQueryResult().queryType() == QueryType.AG || verificationResult.getQueryResult().queryType() == QueryType.AF) && verificationResult.getQueryResult().isQuerySatisfied()) {
                QueryResult queryResult = verificationResult.getQueryResult();
                queryResult.setApproximationInconclusive(true);
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
                value.setNameMapping(composedModel.value2());
            } else if ((verificationResult.getQueryResult().queryType() == QueryType.EF || verificationResult.getQueryResult().queryType() == QueryType.EG) && verificationResult.getQueryResult().isQuerySatisfied() || (verificationResult.getQueryResult().queryType() == QueryType.AG || verificationResult.getQueryResult().queryType() == QueryType.AF) && !verificationResult.getQueryResult().isQuerySatisfied()) {
                if (verificationResult.getTrace() != null) {
                    VerificationResult<TimedArcPetriNetTrace> approxResult = verificationResult;
                    NameMapping nameMapping = model.network().isColored() ? verificationResult.getUnfoldedModel().value2() : composedModel.value2();
                    TimedArcPetriNetNetwork netNetwork = model.network().isColored() ? verificationResult.getUnfoldedModel().value1().parentNetwork() : model.network();
                    VerificationResult<TAPNNetworkTrace> valueNetwork = new VerificationResult<TAPNNetworkTrace>(approxResult.getQueryResult(), this.decomposeTrace(approxResult.getTrace(), nameMapping, netNetwork), this.decomposeTrace(approxResult.getSecondaryTrace(), nameMapping, netNetwork), approxResult.verificationTime(), approxResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
                    valueNetwork.setNameMapping(nameMapping);
                    OverApproximation overaprx = new OverApproximation();
                    if (model.network().isColored()) {
                        transformedOriginalModel = approxResult.getUnfoldedModel();
                        net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery = approxResult.getUnfoldedTab().queries().iterator().next();
                        clonedQuery = new TAPNQuery(dataLayerQuery.getProperty(), dataLayerQuery.getCapacity());
                        ((VerifyTAPNOptions)options).setUnfold(false);
                    }
                    overaprx.makeTraceTAPN(transformedOriginalModel, valueNetwork, clonedQuery);
                    if (options instanceof VerifyTAPNOptions && oldInclusionPlaces != null) {
                        ((VerifyTAPNOptions)options).setInclusionPlaces(oldInclusionPlaces);
                    }
                    MemoryMonitor.cumulateMemory();
                    verificationResult = modelChecker.verify(options, transformedOriginalModel, clonedQuery, null, query, null);
                    if (verificationResult.error()) {
                        options.setTraceOption(oldTraceOption);
                        return new VerificationResult<TimedArcPetriNetTrace>(verificationResult.errorMessage(), verificationResult.verificationTime() + approxResult.verificationTime());
                    }
                    this.renameTraceTransitions(verificationResult.getTrace());
                    this.renameTraceTransitions(verificationResult.getSecondaryTrace());
                    QueryResult queryResult = verificationResult.getQueryResult();
                    if (verificationResult.getQueryResult().queryType() == QueryType.EF && !queryResult.isQuerySatisfied() || verificationResult.getQueryResult().queryType() == QueryType.AG && queryResult.isQuerySatisfied() || verificationResult.getQueryResult().queryType() == QueryType.EG && !queryResult.isQuerySatisfied() || verificationResult.getQueryResult().queryType() == QueryType.AF && queryResult.isQuerySatisfied()) {
                        queryResult.setApproximationInconclusive(true);
                    }
                    value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime() + approxResult.verificationTime(), verificationResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
                    value.setNameMapping(composedModel.value2());
                } else {
                    QueryResult queryResult = verificationResult.getQueryResult();
                    queryResult.setApproximationInconclusive(true);
                    value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
                    value.setNameMapping(composedModel.value2());
                }
            }
        } else {
            value = new VerificationResult<TimedArcPetriNetTrace>(verificationResult.getQueryResult(), verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), verificationResult.getUnfoldedTab());
            value.setNameMapping(composedModel.value2());
        }
        options.setTraceOption(oldTraceOption);
        return value;
    }

    public VerificationResult<TimedArcPetriNetTrace> batchWorker(Tuple<TimedArcPetriNet, NameMapping> composedModel, String options, net.tapaal.gui.petrinet.verification.TAPNQuery query, LoadedBatchProcessingModel model, ModelChecker modelChecker, TAPNQuery queryToVerify, TAPNQuery clonedQuery) throws Exception {
        Tuple<TimedArcPetriNet, NameMapping> transformedOriginalModel = new Tuple<TimedArcPetriNet, NameMapping>(composedModel.value1().copy(), composedModel.value2());
        VerificationResult<TimedArcPetriNetTrace> verificationResult = modelChecker.verifyManually(options, composedModel, queryToVerify, query, null);
        VerificationResult<TimedArcPetriNetTrace> value = null;
        if (verificationResult.error()) {
            return new VerificationResult<TimedArcPetriNetTrace>(verificationResult.errorMessage(), verificationResult.verificationTime());
        }
        if (query != null && query.isOverApproximationEnabled()) {
            if (query.approximationDenominator() == 1) {
                QueryResult queryResult = verificationResult.getQueryResult();
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getUnfoldedModel());
                value.setNameMapping(composedModel.value2());
            } else if (verificationResult.getTrace() != null && ((verificationResult.getQueryResult().queryType() == QueryType.EF || verificationResult.getQueryResult().queryType() == QueryType.EG) && verificationResult.getQueryResult().isQuerySatisfied() || (verificationResult.getQueryResult().queryType() == QueryType.AG || verificationResult.getQueryResult().queryType() == QueryType.AF) && !verificationResult.getQueryResult().isQuerySatisfied())) {
                VerificationResult<TimedArcPetriNetTrace> approxResult = verificationResult;
                NameMapping nameMapping = model.network().isColored() ? verificationResult.getUnfoldedModel().value2() : composedModel.value2();
                TimedArcPetriNetNetwork netNetwork = model.network().isColored() ? verificationResult.getUnfoldedModel().value1().parentNetwork() : model.network();
                VerificationResult<TAPNNetworkTrace> valueNetwork = new VerificationResult<TAPNNetworkTrace>(approxResult.getQueryResult(), this.decomposeTrace(approxResult.getTrace(), nameMapping, netNetwork), this.decomposeTrace(approxResult.getSecondaryTrace(), nameMapping, netNetwork), approxResult.verificationTime(), approxResult.stats(), false, verificationResult.getUnfoldedModel());
                valueNetwork.setNameMapping(nameMapping);
                OverApproximation overaprx = new OverApproximation();
                if (model.network().isColored()) {
                    transformedOriginalModel = approxResult.getUnfoldedModel();
                    net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery = approxResult.getUnfoldedTab().queries().iterator().next();
                    clonedQuery = new TAPNQuery(dataLayerQuery.getProperty(), dataLayerQuery.getCapacity());
                }
                overaprx.makeTraceTAPN(transformedOriginalModel, valueNetwork, clonedQuery);
                MemoryMonitor.cumulateMemory();
                verificationResult = modelChecker.verifyManually(options, transformedOriginalModel, clonedQuery, query, null);
                if (verificationResult.error()) {
                    return new VerificationResult<TimedArcPetriNetTrace>(verificationResult.errorMessage(), verificationResult.verificationTime() + approxResult.verificationTime());
                }
                this.renameTraceTransitions(verificationResult.getTrace());
                this.renameTraceTransitions(verificationResult.getSecondaryTrace());
                QueryResult queryResult = verificationResult.getQueryResult();
                if ((verificationResult.getQueryResult().queryType() == QueryType.EF || verificationResult.getQueryResult().queryType() == QueryType.EG) && !queryResult.isQuerySatisfied() || (verificationResult.getQueryResult().queryType() == QueryType.AG || verificationResult.getQueryResult().queryType() == QueryType.AF) && queryResult.isQuerySatisfied()) {
                    queryResult.setApproximationInconclusive(true);
                }
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, approxResult.getTrace(), approxResult.getSecondaryTrace(), approxResult.verificationTime() + verificationResult.verificationTime(), approxResult.stats(), false, verificationResult.getUnfoldedModel());
                value.setNameMapping(composedModel.value2());
            } else if ((verificationResult.getQueryResult().queryType() == QueryType.EF || verificationResult.getQueryResult().queryType() == QueryType.EG) && !verificationResult.getQueryResult().isQuerySatisfied() || (verificationResult.getQueryResult().queryType() == QueryType.AG || verificationResult.getQueryResult().queryType() == QueryType.AF) && verificationResult.getQueryResult().isQuerySatisfied()) {
                QueryResult queryResult = verificationResult.getQueryResult();
                if (queryResult.hasDeadlock() || queryResult.queryType() == QueryType.EG || queryResult.queryType() == QueryType.AF) {
                    queryResult.setApproximationInconclusive(true);
                }
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getUnfoldedModel());
                value.setNameMapping(composedModel.value2());
            } else {
                QueryResult queryResult = verificationResult.getQueryResult();
                queryResult.setApproximationInconclusive(true);
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getUnfoldedModel());
                value.setNameMapping(composedModel.value2());
            }
        } else if (query != null && query.isUnderApproximationEnabled()) {
            if (query.approximationDenominator() == 1) {
                QueryResult queryResult = verificationResult.getQueryResult();
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getUnfoldedModel());
                value.setNameMapping(composedModel.value2());
            } else if ((verificationResult.getQueryResult().queryType() == QueryType.EF || verificationResult.getQueryResult().queryType() == QueryType.EG) && !verificationResult.getQueryResult().isQuerySatisfied() || (verificationResult.getQueryResult().queryType() == QueryType.AG || verificationResult.getQueryResult().queryType() == QueryType.AF) && verificationResult.getQueryResult().isQuerySatisfied()) {
                QueryResult queryResult = verificationResult.getQueryResult();
                queryResult.setApproximationInconclusive(true);
                value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getUnfoldedModel());
                value.setNameMapping(composedModel.value2());
            } else if ((verificationResult.getQueryResult().queryType() == QueryType.EF || verificationResult.getQueryResult().queryType() == QueryType.EG) && verificationResult.getQueryResult().isQuerySatisfied() || (verificationResult.getQueryResult().queryType() == QueryType.AG || verificationResult.getQueryResult().queryType() == QueryType.AF) && !verificationResult.getQueryResult().isQuerySatisfied()) {
                if (verificationResult.getTrace() != null) {
                    VerificationResult<TimedArcPetriNetTrace> approxResult = verificationResult;
                    NameMapping nameMapping = model.network().isColored() ? verificationResult.getUnfoldedModel().value2() : composedModel.value2();
                    TimedArcPetriNetNetwork netNetwork = model.network().isColored() ? verificationResult.getUnfoldedModel().value1().parentNetwork() : model.network();
                    VerificationResult<TAPNNetworkTrace> valueNetwork = new VerificationResult<TAPNNetworkTrace>(approxResult.getQueryResult(), this.decomposeTrace(approxResult.getTrace(), nameMapping, netNetwork), this.decomposeTrace(approxResult.getSecondaryTrace(), nameMapping, netNetwork), approxResult.verificationTime(), approxResult.stats(), false, verificationResult.getUnfoldedModel());
                    valueNetwork.setNameMapping(nameMapping);
                    OverApproximation overaprx = new OverApproximation();
                    if (model.network().isColored()) {
                        transformedOriginalModel = approxResult.getUnfoldedModel();
                        net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery = approxResult.getUnfoldedTab().queries().iterator().next();
                        clonedQuery = new TAPNQuery(dataLayerQuery.getProperty(), dataLayerQuery.getCapacity());
                    }
                    overaprx.makeTraceTAPN(transformedOriginalModel, valueNetwork, clonedQuery);
                    MemoryMonitor.cumulateMemory();
                    verificationResult = modelChecker.verifyManually(options, transformedOriginalModel, clonedQuery, query, null);
                    if (verificationResult.error()) {
                        return new VerificationResult<TimedArcPetriNetTrace>(verificationResult.errorMessage(), verificationResult.verificationTime() + approxResult.verificationTime());
                    }
                    this.renameTraceTransitions(verificationResult.getTrace());
                    this.renameTraceTransitions(verificationResult.getSecondaryTrace());
                    QueryResult queryResult = verificationResult.getQueryResult();
                    if (verificationResult.getQueryResult().queryType() == QueryType.EF && !queryResult.isQuerySatisfied() || verificationResult.getQueryResult().queryType() == QueryType.AG && queryResult.isQuerySatisfied() || verificationResult.getQueryResult().queryType() == QueryType.EG && !queryResult.isQuerySatisfied() || verificationResult.getQueryResult().queryType() == QueryType.AF && queryResult.isQuerySatisfied()) {
                        queryResult.setApproximationInconclusive(true);
                    }
                    value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime() + approxResult.verificationTime(), verificationResult.stats(), false, verificationResult.getUnfoldedModel());
                    value.setNameMapping(composedModel.value2());
                } else {
                    QueryResult queryResult = verificationResult.getQueryResult();
                    queryResult.setApproximationInconclusive(true);
                    value = new VerificationResult<TimedArcPetriNetTrace>(queryResult, verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getUnfoldedModel());
                    value.setNameMapping(composedModel.value2());
                }
            }
        } else {
            value = new VerificationResult<TimedArcPetriNetTrace>(verificationResult.getQueryResult(), verificationResult.getTrace(), verificationResult.getSecondaryTrace(), verificationResult.verificationTime(), verificationResult.stats(), false, verificationResult.getRawOutput(), verificationResult.getUnfoldedModel(), null);
            value.setNameMapping(composedModel.value2());
        }
        return value;
    }

    private TAPNNetworkTrace decomposeTrace(TimedArcPetriNetTrace trace, NameMapping mapping, TimedArcPetriNetNetwork model) {
        if (trace == null) {
            return null;
        }
        TAPNTraceDecomposer decomposer = new TAPNTraceDecomposer(trace, model, mapping);
        return decomposer.decompose();
    }

    private Map<String, TAPNNetworkTrace> decomposeTrace(Map<String, TimedArcPetriNetTrace> traceMap, NameMapping mapping, TimedArcPetriNetNetwork model) {
        if (traceMap == null || traceMap.size() == 0 || traceMap.values().toArray()[0] == null) {
            return null;
        }
        LinkedHashMap<String, TAPNNetworkTrace> decomposedTracesMap = new LinkedHashMap<String, TAPNNetworkTrace>();
        for (Map.Entry<String, TimedArcPetriNetTrace> entry : traceMap.entrySet()) {
            TAPNTraceDecomposer decomposer = new TAPNTraceDecomposer(entry.getValue(), model, mapping);
            decomposedTracesMap.put(entry.getKey(), decomposer.decompose());
        }
        return decomposedTracesMap;
    }

    private void renameTraceTransitions(TimedArcPetriNetTrace trace) {
        if (trace != null) {
            trace.reduceTraceForOriginalNet("_traceNet_", "PTRACE");
            trace.removeTokens("PBLOCK");
        }
    }

    private Tuple<TimedArcPetriNet, NameMapping> composeModel(LoadedBatchProcessingModel model) {
        TAPNComposer composer = new TAPNComposer(new Messenger(){

            @Override
            public void displayInfoMessage(String message) {
            }

            @Override
            public void displayInfoMessage(String message, String title) {
            }

            @Override
            public void displayErrorMessage(String message) {
            }

            @Override
            public void displayErrorMessage(String message, String title) {
            }

            @Override
            public void displayWrappedErrorMessage(String message, String title) {
            }
        }, false);
        return composer.transformModel(model.network());
    }
}

