/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL.visitors;

import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLTransitionNode;
import dk.aau.cs.TCTL.visitors.VisitorBase;
import dk.aau.cs.util.Tuple;
import java.util.ArrayList;
import java.util.HashSet;

public class VerifyTransitionNamesVisitor
extends VisitorBase {
    private final ArrayList<Tuple<String, String>> templateTransitionNames;

    public VerifyTransitionNamesVisitor(ArrayList<Tuple<String, String>> templateTransitionNames) {
        this.templateTransitionNames = templateTransitionNames;
    }

    public Context verifyTransitionNames(TCTLAbstractProperty query) {
        Context c = new Context();
        query.accept(this, c);
        return c;
    }

    @Override
    public void visit(TCTLTransitionNode transitionNode, Object context) {
        Context c = (Context)context;
        if (!this.templateTransitionNames.contains(new Tuple<String, String>(transitionNode.getTemplate(), transitionNode.getTransition()))) {
            String temp = transitionNode.getTemplate() != "" ? transitionNode.getTemplate() + "." : "";
            c.addIncorrectTransitionName(temp + transitionNode.getTransition());
            c.setResult(false);
        }
    }

    public static class Context {
        private Boolean result = true;
        private final HashSet<String> incorrectTransitionNames = new HashSet();

        public Boolean getResult() {
            return this.result;
        }

        public void setResult(Boolean result) {
            this.result = result;
        }

        public HashSet<String> getIncorrectTransitionNames() {
            return this.incorrectTransitionNames;
        }

        public void addIncorrectTransitionName(String incorrectTransitionName) {
            this.incorrectTransitionNames.add(incorrectTransitionName);
        }
    }
}

