/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL.visitors;

import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.TCTL.visitors.VisitorBase;
import dk.aau.cs.util.Tuple;
import java.util.ArrayList;
import java.util.HashSet;

public class VerifyPlaceNamesVisitor
extends VisitorBase {
    private final ArrayList<Tuple<String, String>> templatePlaceNames;

    public VerifyPlaceNamesVisitor(ArrayList<Tuple<String, String>> templatePlaceNames) {
        this.templatePlaceNames = templatePlaceNames;
    }

    public Context verifyPlaceNames(TCTLAbstractProperty query) {
        Context c = new Context();
        query.accept(this, c);
        return c;
    }

    @Override
    public void visit(TCTLPlaceNode placeNode, Object context) {
        Context c = (Context)context;
        if (!this.templatePlaceNames.contains(new Tuple<String, String>(placeNode.getTemplate(), placeNode.getPlace()))) {
            String temp = placeNode.getTemplate() != "" ? placeNode.getTemplate() + "." : "";
            c.addIncorrectPlaceName(temp + placeNode.getPlace());
            c.setResult(false);
        }
    }

    public static class Context {
        private Boolean result = true;
        private final HashSet<String> incorrectPlaceNames = new HashSet();

        public Boolean getResult() {
            return this.result;
        }

        public void setResult(Boolean result) {
            this.result = result;
        }

        public HashSet<String> getIncorrectPlaceNames() {
            return this.incorrectPlaceNames;
        }

        public void addIncorrectPlaceName(String incorrectPlaceName) {
            this.incorrectPlaceNames.add(incorrectPlaceName);
        }
    }
}

