/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL.visitors;

import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.visitors.LTLQueryVisitor;
import dk.aau.cs.verification.SMCSettings;
import dk.aau.cs.verification.observations.Observation;
import java.util.ArrayList;
import java.util.List;

public class SMCQueryVisitor
extends LTLQueryVisitor {
    private static final String XML_SMC = "smc";
    private static final String XML_TIME_BOUND_TAG = "time-bound";
    private static final String XML_STEP_BOUND_TAG = "step-bound";
    private static final String XML_FALSE_POS_TAG = "false-positives";
    private static final String XML_FALSE_NEG_TAG = "false-negatives";
    private static final String XML_INDIFFERENCE_TAG = "indifference";
    private static final String XML_CONFIDENCE_TAG = "confidence";
    private static final String XML_INTERVAL_WIDTH_TAG = "interval-width";
    private static final String XML_COMPARE_TO_FLOAT_TAG = "compare-to";
    private static final String XML_NUMERIC_PFRECISION = "numeric-precision";
    private static final String XML_OBSERVATIONS = "observations";

    public String getXMLQueryFor(TCTLAbstractProperty property, String queryName, SMCSettings settings) {
        this.buildXMLQuery(property, queryName, settings, true);
        return this.getFormatted();
    }

    public void buildXMLQuery(TCTLAbstractProperty property, String queryName, SMCSettings settings) {
        this.buildXMLQuery(property, queryName, settings, false);
    }

    public void buildXMLQuery(TCTLAbstractProperty property, String queryName, SMCSettings settings, boolean discardDisabled) {
        this.xmlQuery.append(this.startTag("property") + this.queryInfo(queryName) + this.smcTag(settings));
        List<Observation> observations = settings.getObservations();
        if (!observations.isEmpty()) {
            this.xmlQuery.append(this.observationTag(observations, discardDisabled));
        }
        this.xmlQuery.append(this.startTag("formula"));
        property.accept(this, null);
        this.xmlQuery.append(this.endTag("formula") + this.endTag("property"));
    }

    private String smcTag(SMCSettings settings) {
        Object tagContent = XML_SMC;
        if (settings.timeBound < Integer.MAX_VALUE) {
            tagContent = (String)tagContent + this.tagAttribute(XML_TIME_BOUND_TAG, settings.timeBound);
        }
        if (settings.stepBound < Integer.MAX_VALUE) {
            tagContent = (String)tagContent + this.tagAttribute(XML_STEP_BOUND_TAG, settings.stepBound);
        }
        if (settings.compareToFloat) {
            tagContent = (String)tagContent + this.tagAttribute(XML_FALSE_POS_TAG, settings.falsePositives);
            tagContent = (String)tagContent + this.tagAttribute(XML_FALSE_NEG_TAG, settings.falseNegatives);
            tagContent = (String)tagContent + this.tagAttribute(XML_INDIFFERENCE_TAG, settings.indifferenceWidth);
            tagContent = (String)tagContent + this.tagAttribute(XML_COMPARE_TO_FLOAT_TAG, settings.geqThan);
        } else {
            tagContent = (String)tagContent + this.tagAttribute(XML_CONFIDENCE_TAG, settings.confidence);
            tagContent = (String)tagContent + this.tagAttribute(XML_INTERVAL_WIDTH_TAG, settings.estimationIntervalWidth);
        }
        tagContent = (String)tagContent + this.tagAttribute(XML_NUMERIC_PFRECISION, settings.getNumericPrecision());
        return this.emptyElement((String)tagContent);
    }

    private String observationTag(List<Observation> observations, boolean discardDisabled) {
        Object observationXml = this.startTag(XML_OBSERVATIONS);
        ArrayList<Observation> observationsCopy = new ArrayList<Observation>(observations);
        if (discardDisabled) {
            observationsCopy.removeIf(observation -> !observation.isEnabled());
        }
        for (Observation observation2 : observationsCopy) {
            observationXml = (String)observationXml + observation2.toXml();
        }
        observationXml = (String)observationXml + this.endTag(XML_OBSERVATIONS);
        return observationXml;
    }

    private String tagAttribute(String name, float value) {
        return " " + name + "=\"" + String.valueOf(value) + "\"";
    }

    private String tagAttribute(String name, long value) {
        return " " + name + "=\"" + Long.toUnsignedString(value) + "\"";
    }

    private String tagAttribute(String name, int value) {
        return " " + name + "=\"" + String.valueOf(value) + "\"";
    }
}

