/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL.visitors;

import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.TCTL.visitors.QueryVisitor;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import java.util.Hashtable;

public class CombiTranslationQueryVisitor
extends QueryVisitor {
    protected static final String ID_TYPE = "id_t";
    protected static final String PLOCK = "P_lock";
    protected static final String TOKEN_TEMPLATE_NAME = "Token";
    private final boolean useSymmetry;
    private final int totalTokens;
    private final TimedArcPetriNet model;
    private final Hashtable<String, Boolean> placeNameToTimed;
    private final int maxDegDif;
    private final int initTransitions;
    private final int maxTimeIn;

    public CombiTranslationQueryVisitor(boolean useSymmetry, int totalTokens, TimedArcPetriNet model, Hashtable<String, Boolean> placeNameToTimed, int maxDegDif, int initTransitions, int maxTimeIn) {
        this.useSymmetry = useSymmetry;
        this.totalTokens = totalTokens;
        this.model = model;
        this.placeNameToTimed = placeNameToTimed;
        this.maxDegDif = maxDegDif;
        this.initTransitions = initTransitions;
        this.maxTimeIn = maxTimeIn;
    }

    @Override
    public void visit(TCTLPlaceNode placeNode, Object context) {
        boolean timed = true;
        for (TimedPlace p : this.model.places()) {
            if (this.placeNameToTimed.get(p.name()).booleanValue() || !placeNode.getPlace().equals(p.name())) continue;
            timed = false;
        }
        if (timed) {
            if (this.maxDegDif == 0 && this.initTransitions == 0 && this.maxTimeIn == 0) {
                this.append("0");
            } else if (this.useSymmetry) {
                this.append("(sum(i:");
                this.append(ID_TYPE);
                this.append(")");
                this.append(TOKEN_TEMPLATE_NAME);
                this.append("(i).");
                this.append(placeNode.getPlace());
                this.append(")");
            } else if (this.totalTokens == 0) {
                this.append("(");
                this.append(TOKEN_TEMPLATE_NAME);
                this.append(".");
                this.append(placeNode.getPlace());
                this.append(")");
            } else {
                this.append("(");
                for (int i = 0; i < this.totalTokens; ++i) {
                    if (i > 0) {
                        this.append(" + ");
                    }
                    this.append(TOKEN_TEMPLATE_NAME);
                    this.append(i);
                    this.append(".");
                    this.append(placeNode.getPlace());
                }
                this.append(")");
            }
        } else {
            this.append("X_");
            this.append(placeNode.getPlace());
        }
    }

    @Override
    protected void addEnding(QueryVisitor.QueryType type) {
        if (type == QueryVisitor.QueryType.EF || type == QueryVisitor.QueryType.AF) {
            this.append(" && ");
        } else {
            this.append(" || !");
        }
        this.append("Control.");
        this.append(PLOCK);
    }
}

