/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL.XMLParsing;

import dk.aau.cs.TCTL.AritmeticOperator;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLAUNode;
import dk.aau.cs.TCTL.TCTLAXNode;
import dk.aau.cs.TCTL.TCTLAbstractPathProperty;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.TCTLAndListNode;
import dk.aau.cs.TCTL.TCTLAtomicPropositionNode;
import dk.aau.cs.TCTL.TCTLConstNode;
import dk.aau.cs.TCTL.TCTLDeadlockNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.TCTL.TCTLEUNode;
import dk.aau.cs.TCTL.TCTLEXNode;
import dk.aau.cs.TCTL.TCTLFalseNode;
import dk.aau.cs.TCTL.TCTLNotNode;
import dk.aau.cs.TCTL.TCTLOrListNode;
import dk.aau.cs.TCTL.TCTLPathToStateConverter;
import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.TCTL.TCTLTermListNode;
import dk.aau.cs.TCTL.TCTLTransitionNode;
import dk.aau.cs.TCTL.TCTLTrueNode;
import dk.aau.cs.TCTL.XMLParsing.QueryWrapper;
import dk.aau.cs.TCTL.XMLParsing.XMLQueryParseException;
import dk.aau.cs.debug.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLCTLQueryParser {
    private Node property;
    private QueryWrapper queryWrapper;
    private static final String ERROR_MESSAGE = "Could not parse XML tag: ";

    public static boolean parse(Node prop, QueryWrapper queryWrapper) {
        XMLCTLQueryParser parser = new XMLCTLQueryParser(prop, queryWrapper);
        queryWrapper.setName(parser.parsePropertyName());
        try {
            queryWrapper.setProp(parser.AbstractProperty());
        }
        catch (XMLQueryParseException e) {
            queryWrapper.setException(e);
            Logger.log(e);
            return false;
        }
        return true;
    }

    public static TCTLAbstractProperty parse(Node prop) throws XMLQueryParseException {
        XMLCTLQueryParser parser = new XMLCTLQueryParser(prop);
        return parser.AbstractProperty();
    }

    public final TCTLAbstractProperty AbstractProperty() throws XMLQueryParseException {
        Node formula = XMLCTLQueryParser.findSubNode("formula", this.property);
        if (formula != null) {
            return this.parseFormula(this.getFirstChildNode(formula));
        }
        throw new XMLQueryParseException(ERROR_MESSAGE + this.property.getNodeName());
    }

    private String parsePropertyName() {
        String result;
        Node idNode = XMLCTLQueryParser.findSubNode("id", this.property);
        if (idNode == null || (result = XMLCTLQueryParser.getText(idNode)) == null) {
            result = "Query Comment/Name Here";
        }
        return result;
    }

    private TCTLAbstractProperty parseFormula(Node property) throws XMLQueryParseException {
        Node child = this.getFirstChildNode(property);
        String nodeName = property.getNodeName();
        String childNodeName = "";
        if (child != null) {
            childNodeName = child.getNodeName();
        }
        if (nodeName.equals("invariant")) {
            TCTLAbstractProperty childProperty = this.parseFormula(this.getFirstChildNode(property));
            this.queryWrapper.negateQuery();
            if (childProperty instanceof TCTLAbstractPathProperty) {
                childProperty = new TCTLPathToStateConverter((TCTLAbstractPathProperty)childProperty);
            }
            return new TCTLEFNode(new TCTLNotNode((TCTLAbstractStateProperty)childProperty));
        }
        if (nodeName.equals("impossibility")) {
            TCTLAbstractProperty childProperty = this.parseFormula(this.getFirstChildNode(property));
            this.queryWrapper.negateQuery();
            if (childProperty instanceof TCTLAbstractPathProperty) {
                childProperty = new TCTLPathToStateConverter((TCTLAbstractPathProperty)childProperty);
            }
            return new TCTLEFNode((TCTLAbstractStateProperty)childProperty);
        }
        if (nodeName.equals("possibility")) {
            TCTLAbstractProperty childProperty = this.parseFormula(this.getFirstChildNode(property));
            if (childProperty instanceof TCTLAbstractPathProperty) {
                childProperty = new TCTLPathToStateConverter((TCTLAbstractPathProperty)childProperty);
            }
            return new TCTLEFNode((TCTLAbstractStateProperty)childProperty);
        }
        if (nodeName.equals("exists-path")) {
            if (childNodeName.equals("finally")) {
                TCTLAbstractProperty childProperty = this.parseFormula(this.getFirstChildNode(child));
                if (childProperty instanceof TCTLAbstractPathProperty) {
                    return new TCTLEFNode(new TCTLPathToStateConverter((TCTLAbstractPathProperty)childProperty));
                }
                return new TCTLEFNode((TCTLAbstractStateProperty)childProperty);
            }
            if (childNodeName.equals("globally")) {
                TCTLAbstractProperty childProperty = this.parseFormula(this.getFirstChildNode(child));
                if (childProperty instanceof TCTLAbstractPathProperty) {
                    return new TCTLEGNode(new TCTLPathToStateConverter((TCTLAbstractPathProperty)childProperty));
                }
                return new TCTLEGNode((TCTLAbstractStateProperty)childProperty);
            }
            if (childNodeName.equals("next")) {
                TCTLAbstractProperty childProperty = this.parseFormula(this.getFirstChildNode(child));
                if (childProperty instanceof TCTLAbstractPathProperty) {
                    return new TCTLEXNode(new TCTLPathToStateConverter((TCTLAbstractPathProperty)childProperty));
                }
                return new TCTLEXNode((TCTLAbstractStateProperty)childProperty);
            }
            if (childNodeName.equals("until")) {
                ArrayList<Node> children = this.getAllChildren(child);
                if (children.size() != 2) {
                    Logger.log("ERROR");
                }
                TCTLAbstractProperty before = this.parseFormula(this.getFirstChildNode(children.get(0)));
                TCTLAbstractProperty reach = this.parseFormula(this.getFirstChildNode(children.get(1)));
                if (before instanceof TCTLAbstractPathProperty) {
                    before = new TCTLPathToStateConverter((TCTLAbstractPathProperty)before);
                }
                if (reach instanceof TCTLAbstractPathProperty) {
                    reach = new TCTLPathToStateConverter((TCTLAbstractPathProperty)reach);
                }
                return new TCTLEUNode((TCTLAbstractStateProperty)before, (TCTLAbstractStateProperty)reach);
            }
            throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
        }
        if (nodeName.equals("all-paths")) {
            if (childNodeName.equals("finally")) {
                TCTLAbstractProperty childProperty = this.parseFormula(this.getFirstChildNode(child));
                if (childProperty instanceof TCTLAbstractPathProperty) {
                    return new TCTLAFNode(new TCTLPathToStateConverter((TCTLAbstractPathProperty)childProperty));
                }
                return new TCTLAFNode((TCTLAbstractStateProperty)childProperty);
            }
            if (childNodeName.equals("globally")) {
                TCTLAbstractProperty childProperty = this.parseFormula(this.getFirstChildNode(child));
                if (childProperty instanceof TCTLAbstractPathProperty) {
                    return new TCTLAGNode(new TCTLPathToStateConverter((TCTLAbstractPathProperty)childProperty));
                }
                return new TCTLAGNode((TCTLAbstractStateProperty)childProperty);
            }
            if (childNodeName.equals("next")) {
                TCTLAbstractProperty childProperty = this.parseFormula(this.getFirstChildNode(child));
                if (childProperty instanceof TCTLAbstractPathProperty) {
                    return new TCTLAXNode(new TCTLPathToStateConverter((TCTLAbstractPathProperty)childProperty));
                }
                return new TCTLAXNode((TCTLAbstractStateProperty)childProperty);
            }
            if (childNodeName.equals("until")) {
                ArrayList<Node> children = this.getAllChildren(child);
                if (children.size() != 2) {
                    Logger.log("ERROR");
                }
                TCTLAbstractProperty before = this.parseFormula(this.getFirstChildNode(children.get(0)));
                TCTLAbstractProperty reach = this.parseFormula(this.getFirstChildNode(children.get(1)));
                if (before instanceof TCTLAbstractPathProperty) {
                    before = new TCTLPathToStateConverter((TCTLAbstractPathProperty)before);
                }
                if (reach instanceof TCTLAbstractPathProperty) {
                    reach = new TCTLPathToStateConverter((TCTLAbstractPathProperty)reach);
                }
                return new TCTLAUNode((TCTLAbstractStateProperty)before, (TCTLAbstractStateProperty)reach);
            }
            throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
        }
        if (nodeName.equals("deadlock")) {
            return new TCTLDeadlockNode();
        }
        if (nodeName.equals("true")) {
            return new TCTLTrueNode();
        }
        if (nodeName.equals("false")) {
            return new TCTLFalseNode();
        }
        if (nodeName.equals("negation")) {
            ArrayList<Node> children = this.getAllChildren(property);
            if (children.size() != 1) {
                throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
            }
            TCTLAbstractProperty booleanFormulaChild = this.parseFormula(this.getFirstChildNode(property));
            if (booleanFormulaChild instanceof TCTLAbstractPathProperty) {
                booleanFormulaChild = new TCTLPathToStateConverter((TCTLAbstractPathProperty)booleanFormulaChild);
            }
            return new TCTLNotNode((TCTLAbstractStateProperty)booleanFormulaChild);
        }
        if (nodeName.equals("conjunction") || nodeName.equals("disjunction")) {
            ArrayList<Node> children = this.getAllChildren(property);
            if (children.size() < 2) {
                throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
            }
            ArrayList<TCTLAbstractStateProperty> boolExpList = new ArrayList<TCTLAbstractStateProperty>();
            for (Node n : children) {
                TCTLAbstractProperty p = this.parseFormula(n);
                if (p instanceof TCTLAbstractPathProperty) {
                    p = new TCTLPathToStateConverter((TCTLAbstractPathProperty)p);
                }
                boolExpList.add((TCTLAbstractStateProperty)p);
            }
            if (nodeName == "conjunction") {
                return new TCTLAndListNode(boolExpList);
            }
            return new TCTLOrListNode(boolExpList);
        }
        if (nodeName.equals("exclusive-disjunction")) {
            ArrayList<Node> children = this.getAllChildren(property);
            if (children.size() != 2) {
                throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
            }
            ArrayList<TCTLAbstractStateProperty> boolExpList = new ArrayList<TCTLAbstractStateProperty>();
            TCTLAbstractProperty left = this.parseFormula(children.get(0));
            TCTLAbstractProperty right = this.parseFormula(children.get(1));
            if (left instanceof TCTLAbstractPathProperty) {
                left = new TCTLPathToStateConverter((TCTLAbstractPathProperty)left);
            }
            if (right instanceof TCTLAbstractPathProperty) {
                right = new TCTLPathToStateConverter((TCTLAbstractPathProperty)right);
            }
            boolExpList.add((TCTLAbstractStateProperty)left);
            boolExpList.add((TCTLAbstractStateProperty)right);
            TCTLAndListNode leftSubFormula = new TCTLAndListNode((TCTLAbstractStateProperty)boolExpList.get(0), new TCTLNotNode((TCTLAbstractStateProperty)boolExpList.get(1)));
            TCTLAndListNode rightSubFormula = new TCTLAndListNode(new TCTLNotNode((TCTLAbstractStateProperty)boolExpList.get(0)), (TCTLAbstractStateProperty)boolExpList.get(1));
            return new TCTLOrListNode(leftSubFormula, rightSubFormula);
        }
        if (nodeName.equals("implication")) {
            ArrayList<Node> children = this.getAllChildren(property);
            if (children.size() != 2) {
                throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
            }
            ArrayList<TCTLAbstractStateProperty> boolExpList = new ArrayList<TCTLAbstractStateProperty>();
            TCTLAbstractProperty left = this.parseFormula(children.get(0));
            TCTLAbstractProperty right = this.parseFormula(children.get(1));
            if (left instanceof TCTLAbstractPathProperty) {
                left = new TCTLPathToStateConverter((TCTLAbstractPathProperty)left);
            }
            if (right instanceof TCTLAbstractPathProperty) {
                right = new TCTLPathToStateConverter((TCTLAbstractPathProperty)right);
            }
            boolExpList.add((TCTLAbstractStateProperty)left);
            boolExpList.add((TCTLAbstractStateProperty)right);
            return new TCTLOrListNode(new TCTLNotNode((TCTLAbstractStateProperty)boolExpList.get(0)), (TCTLAbstractStateProperty)boolExpList.get(1));
        }
        if (nodeName.equals("equivalence")) {
            ArrayList<Node> children = this.getAllChildren(property);
            if (children.size() != 2) {
                throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
            }
            ArrayList<TCTLAbstractStateProperty> boolExpList = new ArrayList<TCTLAbstractStateProperty>();
            TCTLAbstractProperty left = this.parseFormula(children.get(0));
            TCTLAbstractProperty right = this.parseFormula(children.get(1));
            if (left instanceof TCTLAbstractPathProperty) {
                left = new TCTLPathToStateConverter((TCTLAbstractPathProperty)left);
            }
            if (right instanceof TCTLAbstractPathProperty) {
                right = new TCTLPathToStateConverter((TCTLAbstractPathProperty)right);
            }
            boolExpList.add((TCTLAbstractStateProperty)left);
            boolExpList.add((TCTLAbstractStateProperty)right);
            TCTLAndListNode leftSubFormula = new TCTLAndListNode((TCTLAbstractStateProperty)boolExpList.get(0), (TCTLAbstractStateProperty)boolExpList.get(1));
            TCTLAndListNode rightSubFormula = new TCTLAndListNode(new TCTLNotNode((TCTLAbstractStateProperty)boolExpList.get(0)), new TCTLNotNode((TCTLAbstractStateProperty)boolExpList.get(1)));
            return new TCTLOrListNode(leftSubFormula, rightSubFormula);
        }
        if (nodeName.equals("integer-eq") || nodeName.equals("integer-ne") || nodeName.equals("integer-lt") || nodeName.equals("integer-le") || nodeName.equals("integer-gt") || nodeName.equals("integer-ge")) {
            ArrayList<Node> children = this.getAllChildren(property);
            if (children.size() != 2) {
                throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
            }
            TCTLAbstractStateProperty subformula1 = this.parseIntegerExpression(children.get(0));
            TCTLAbstractStateProperty subformula2 = this.parseIntegerExpression(children.get(1));
            if (nodeName.equals("integer-eq")) {
                return new TCTLAtomicPropositionNode(subformula1, "=", subformula2);
            }
            if (nodeName.equals("integer-ne")) {
                return new TCTLAtomicPropositionNode(subformula1, "!=", subformula2);
            }
            if (nodeName.equals("integer-lt")) {
                return new TCTLAtomicPropositionNode(subformula1, "<", subformula2);
            }
            if (nodeName.equals("integer-le")) {
                return new TCTLAtomicPropositionNode(subformula1, "<=", subformula2);
            }
            if (nodeName.equals("integer-gt")) {
                return new TCTLAtomicPropositionNode(subformula1, ">", subformula2);
            }
            if (nodeName.equals("integer-ge")) {
                return new TCTLAtomicPropositionNode(subformula1, ">=", subformula2);
            }
        } else {
            if (nodeName.equals("is-fireable")) {
                ArrayList<Node> children = this.getAllChildren(property);
                if (children.isEmpty()) {
                    throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
                }
                if (children.size() == 1) {
                    String[] splits = XMLCTLQueryParser.getText(children.get(0)).replace("\n", "").split("\\.");
                    if (splits.length > 1) {
                        return new TCTLTransitionNode(splits[0], splits[1]);
                    }
                    return new TCTLTransitionNode(splits[0]);
                }
                ArrayList<TCTLAbstractStateProperty> transitions = new ArrayList<TCTLAbstractStateProperty>();
                for (Node n : children) {
                    String[] splits = XMLCTLQueryParser.getText(n).replace("\n", "").split("\\.");
                    if (splits.length > 1) {
                        transitions.add(new TCTLTransitionNode(splits[0], splits[1]));
                        continue;
                    }
                    transitions.add(new TCTLTransitionNode(splits[0]));
                }
                return new TCTLOrListNode(transitions);
            }
            if (nodeName.equals("control")) {
                return this.parseFormula(child);
            }
        }
        throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
    }

    private TCTLAbstractStateProperty parseIntegerExpression(Node integerExpression) throws XMLQueryParseException {
        String nodeName = integerExpression.getNodeName();
        if (nodeName.equals("integer-constant")) {
            int result;
            String value = XMLCTLQueryParser.getText(integerExpression);
            if (value == null) {
                throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
            }
            value = value.replace("\n", "");
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
            }
            return new TCTLConstNode(result);
        }
        if (nodeName.equals("tokens-count")) {
            ArrayList<Node> children = this.getAllChildren(integerExpression);
            if (children.size() < 1) {
                throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
            }
            if (children.size() == 1) {
                String[] splits = XMLCTLQueryParser.getText(children.get(0)).replace("\n", "").split("\\.");
                if (splits.length > 1) {
                    return new TCTLPlaceNode(splits[0], splits[1]);
                }
                return new TCTLPlaceNode(splits[0]);
            }
            ArrayList<TCTLAbstractStateProperty> terms = new ArrayList<TCTLAbstractStateProperty>();
            Iterator<Node> itr = children.iterator();
            while (itr.hasNext()) {
                Node n = itr.next();
                String[] splits = XMLCTLQueryParser.getText(n).replace("\n", "").split("\\.");
                if (splits.length > 1) {
                    terms.add(new TCTLPlaceNode(splits[0], splits[1]));
                } else {
                    terms.add(new TCTLPlaceNode(splits[0]));
                }
                if (!itr.hasNext()) continue;
                terms.add(new AritmeticOperator("+"));
            }
            return new TCTLTermListNode(terms);
        }
        if (nodeName.equals("integer-sum") || nodeName.equals("integer-product") || nodeName.equals("integer-difference")) {
            ArrayList<Node> children = this.getAllChildren(integerExpression);
            Iterator<Node> itr = children.iterator();
            if (children.size() < 2) {
                throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
            }
            ArrayList<TCTLAbstractStateProperty> intExpList = new ArrayList<TCTLAbstractStateProperty>();
            while (itr.hasNext()) {
                Node n = itr.next();
                intExpList.add(this.parseIntegerExpression(n));
                if (!itr.hasNext()) continue;
                if (nodeName.equals("integer-sum")) {
                    intExpList.add(new AritmeticOperator("+"));
                    continue;
                }
                if (nodeName.equals("integer-product")) {
                    intExpList.add(new AritmeticOperator("*"));
                    continue;
                }
                intExpList.add(new AritmeticOperator("-"));
            }
            return new TCTLTermListNode(intExpList);
        }
        throw new XMLQueryParseException(ERROR_MESSAGE + nodeName);
    }

    public static Node findSubNode(String name, Node node) {
        if (node.getNodeType() != 1) {
            return null;
        }
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node subNode = children.item(i);
            if (subNode.getNodeType() != 1 || !subNode.getNodeName().equals(name)) continue;
            return subNode;
        }
        return null;
    }

    private ArrayList<Node> getAllChildren(Node parentNode) {
        NodeList children = parentNode.getChildNodes();
        ArrayList<Node> elementNodes = new ArrayList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            elementNodes.add(node);
        }
        return elementNodes;
    }

    public static String getText(Node node) {
        String result = null;
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node subNode = children.item(i);
            if (subNode.getNodeType() != 3) continue;
            result = subNode.getNodeValue();
        }
        return result;
    }

    public int getChildCount(Node node) {
        int result = 0;
        if (!node.hasChildNodes()) {
            return result;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node subNode = children.item(i);
            if (subNode.getNodeType() != 1) continue;
            ++result;
        }
        return result;
    }

    private Node getFirstChildNode(Node parent) {
        Node child;
        for (child = parent.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return child;
    }

    public XMLCTLQueryParser(Node prop, QueryWrapper qw) {
        this.property = prop;
        this.queryWrapper = qw;
    }

    public XMLCTLQueryParser(Node prop) {
        this.property = prop;
    }
}

