/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL;

import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.visitors.ITCTLVisitor;
import dk.aau.cs.io.NamePurifier;

public class TCTLTransitionNode
extends TCTLAbstractStateProperty {
    String template;
    String transition;
    String trace;

    public TCTLTransitionNode(String template, String transition, String trace) {
        this.template = NamePurifier.purify(template);
        this.transition = NamePurifier.purify(transition);
        this.trace = trace;
    }

    public TCTLTransitionNode(String template, String transition) {
        this.template = NamePurifier.purify(template);
        this.transition = NamePurifier.purify(transition);
        this.trace = "";
    }

    public TCTLTransitionNode(String transition) {
        this("", transition);
        this.trace = "";
    }

    @Override
    public TCTLAbstractStateProperty replace(TCTLAbstractProperty object1, TCTLAbstractProperty object2) {
        if (this == object1 && object2 instanceof TCTLAbstractStateProperty) {
            TCTLAbstractStateProperty obj2 = (TCTLAbstractStateProperty)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        return this;
    }

    @Override
    public void convertForReducedNet(String templateName) {
        this.transition = this.template + "_" + this.transition;
        this.template = templateName;
    }

    @Override
    public TCTLAbstractStateProperty copy() {
        if (!this.trace.equals("")) {
            return new TCTLTransitionNode(this.template, this.transition, this.trace);
        }
        return new TCTLTransitionNode(this.template, this.transition);
    }

    @Override
    public void accept(ITCTLVisitor visitor, Object context) {
        visitor.visit(this, context);
    }

    @Override
    public boolean containsAtomicPropositionWithSpecificPlaceInTemplate(String templateName, String placeName) {
        return false;
    }

    @Override
    public boolean containsAtomicPropositionWithSpecificTransitionInTemplate(String templateName, String transitionName) {
        return this.transition.equals(transitionName) && this.template.equals(templateName);
    }

    @Override
    public boolean containsPlaceHolder() {
        return false;
    }

    @Override
    public boolean hasNestedPathQuantifiers() {
        return false;
    }

    @Override
    public TCTLAbstractProperty findFirstPlaceHolder() {
        return null;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTransition() {
        return this.transition;
    }

    public void setTransition(String transition) {
        this.transition = transition;
    }

    public String toString() {
        if (this.template.equals("")) {
            return this.transition;
        }
        if (this.trace.equals("")) {
            return this.template + "." + this.transition;
        }
        return this.trace + "." + this.template + "." + this.transition;
    }

    public String getTrace() {
        return this.trace;
    }
}

