/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL;

import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.visitors.ITCTLVisitor;
import dk.aau.cs.io.NamePurifier;

public class TCTLPlaceNode
extends TCTLAbstractStateProperty {
    String template;
    String place;

    public TCTLPlaceNode(String template, String place) {
        this.template = NamePurifier.purify(template);
        this.place = NamePurifier.purify(place);
    }

    public TCTLPlaceNode(String place) {
        this("", place);
    }

    @Override
    public TCTLAbstractStateProperty replace(TCTLAbstractProperty object1, TCTLAbstractProperty object2) {
        if (this == object1 && object2 instanceof TCTLAbstractStateProperty) {
            TCTLAbstractStateProperty obj2 = (TCTLAbstractStateProperty)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        return this;
    }

    @Override
    public void convertForReducedNet(String templateName) {
        this.place = this.template.isEmpty() ? "Shared_" + this.place : this.template + "_" + this.place;
        this.template = templateName;
    }

    @Override
    public TCTLAbstractStateProperty copy() {
        return new TCTLPlaceNode(this.template, this.place);
    }

    @Override
    public void accept(ITCTLVisitor visitor, Object context) {
        visitor.visit(this, context);
    }

    @Override
    public boolean containsAtomicPropositionWithSpecificPlaceInTemplate(String templateName, String placeName) {
        return this.place.equals(placeName) && this.template.equals(templateName);
    }

    @Override
    public boolean containsAtomicPropositionWithSpecificTransitionInTemplate(String templateName, String transitionName) {
        return false;
    }

    @Override
    public boolean containsPlaceHolder() {
        return false;
    }

    @Override
    public boolean hasNestedPathQuantifiers() {
        return false;
    }

    @Override
    public TCTLAbstractProperty findFirstPlaceHolder() {
        return null;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String toString() {
        return (String)(this.template == "" ? "" : this.template + ".") + this.place;
    }
}

